/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.WorkRequest;
import java.beans.ConstructorProperties;

public class GetWorkRequestResponse {
    private String etag;
    private Float retryAfter;
    private String opcRequestId;
    private WorkRequest workRequest;

    @ConstructorProperties(value={"etag", "retryAfter", "opcRequestId", "workRequest"})
    GetWorkRequestResponse(String etag, Float retryAfter, String opcRequestId, WorkRequest workRequest) {
        this.etag = etag;
        this.retryAfter = retryAfter;
        this.opcRequestId = opcRequestId;
        this.workRequest = workRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public Float getRetryAfter() {
        return this.retryAfter;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public WorkRequest getWorkRequest() {
        return this.workRequest;
    }

    public static class Builder {
        private String etag;
        private Float retryAfter;
        private String opcRequestId;
        private WorkRequest workRequest;

        public Builder copy(GetWorkRequestResponse o) {
            this.etag(o.getEtag());
            this.retryAfter(o.getRetryAfter());
            this.opcRequestId(o.getOpcRequestId());
            this.workRequest(o.getWorkRequest());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder retryAfter(Float retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder workRequest(WorkRequest workRequest) {
            this.workRequest = workRequest;
            return this;
        }

        public GetWorkRequestResponse build() {
            return new GetWorkRequestResponse(this.etag, this.retryAfter, this.opcRequestId, this.workRequest);
        }

        public String toString() {
            return "GetWorkRequestResponse.Builder(etag=" + this.etag + ", retryAfter=" + this.retryAfter + ", opcRequestId=" + this.opcRequestId + ", workRequest=" + this.workRequest + ")";
        }
    }
}

