/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.AddressListSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListAddressListsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<AddressListSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListAddressListsResponse(String opcNextPage, String opcRequestId, List<AddressListSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<AddressListSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<AddressListSummary> items;

        public Builder copy(ListAddressListsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<AddressListSummary> items) {
            this.items = items;
            return this;
        }

        public ListAddressListsResponse build() {
            return new ListAddressListsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListAddressListsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

