/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.CachingRuleSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListCachingRulesResponse {
    private String etag;
    private String opcNextPage;
    private String opcRequestId;
    private List<CachingRuleSummary> items;

    @ConstructorProperties(value={"etag", "opcNextPage", "opcRequestId", "items"})
    ListCachingRulesResponse(String etag, String opcNextPage, String opcRequestId, List<CachingRuleSummary> items) {
        this.etag = etag;
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<CachingRuleSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String etag;
        private String opcNextPage;
        private String opcRequestId;
        private List<CachingRuleSummary> items;

        public Builder copy(ListCachingRulesResponse o) {
            this.etag(o.getEtag());
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<CachingRuleSummary> items) {
            this.items = items;
            return this;
        }

        public ListCachingRulesResponse build() {
            return new ListCachingRulesResponse(this.etag, this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListCachingRulesResponse.Builder(etag=" + this.etag + ", opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

