/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.Captcha;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListCaptchasResponse {
    private String etag;
    private String opcNextPage;
    private String opcRequestId;
    private List<Captcha> items;

    @ConstructorProperties(value={"etag", "opcNextPage", "opcRequestId", "items"})
    ListCaptchasResponse(String etag, String opcNextPage, String opcRequestId, List<Captcha> items) {
        this.etag = etag;
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Captcha> getItems() {
        return this.items;
    }

    public static class Builder {
        private String etag;
        private String opcNextPage;
        private String opcRequestId;
        private List<Captcha> items;

        public Builder copy(ListCaptchasResponse o) {
            this.etag(o.getEtag());
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<Captcha> items) {
            this.items = items;
            return this;
        }

        public ListCaptchasResponse build() {
            return new ListCaptchasResponse(this.etag, this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListCaptchasResponse.Builder(etag=" + this.etag + ", opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

