/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.CertificateSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListCertificatesResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<CertificateSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListCertificatesResponse(String opcNextPage, String opcRequestId, List<CertificateSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<CertificateSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<CertificateSummary> items;

        public Builder copy(ListCertificatesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<CertificateSummary> items) {
            this.items = items;
            return this;
        }

        public ListCertificatesResponse build() {
            return new ListCertificatesResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListCertificatesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

