/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.CustomProtectionRuleSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListCustomProtectionRulesResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<CustomProtectionRuleSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListCustomProtectionRulesResponse(String opcNextPage, String opcRequestId, List<CustomProtectionRuleSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<CustomProtectionRuleSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<CustomProtectionRuleSummary> items;

        public Builder copy(ListCustomProtectionRulesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<CustomProtectionRuleSummary> items) {
            this.items = items;
            return this;
        }

        public ListCustomProtectionRulesResponse build() {
            return new ListCustomProtectionRulesResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListCustomProtectionRulesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

