/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.EdgeSubnet;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListEdgeSubnetsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<EdgeSubnet> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListEdgeSubnetsResponse(String opcNextPage, String opcRequestId, List<EdgeSubnet> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<EdgeSubnet> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<EdgeSubnet> items;

        public Builder copy(ListEdgeSubnetsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<EdgeSubnet> items) {
            this.items = items;
            return this;
        }

        public ListEdgeSubnetsResponse build() {
            return new ListEdgeSubnetsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListEdgeSubnetsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

