/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.ThreatFeed;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListThreatFeedsResponse {
    private String etag;
    private String opcRequestId;
    private String opcNextPage;
    private List<ThreatFeed> items;

    @ConstructorProperties(value={"etag", "opcRequestId", "opcNextPage", "items"})
    ListThreatFeedsResponse(String etag, String opcRequestId, String opcNextPage, List<ThreatFeed> items) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<ThreatFeed> getItems() {
        return this.items;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private String opcNextPage;
        private List<ThreatFeed> items;

        public Builder copy(ListThreatFeedsResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<ThreatFeed> items) {
            this.items = items;
            return this;
        }

        public ListThreatFeedsResponse build() {
            return new ListThreatFeedsResponse(this.etag, this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListThreatFeedsResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

