/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.WafLog;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWafLogsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<WafLog> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListWafLogsResponse(String opcRequestId, String opcNextPage, List<WafLog> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<WafLog> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<WafLog> items;

        public Builder copy(ListWafLogsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<WafLog> items) {
            this.items = items;
            return this;
        }

        public ListWafLogsResponse build() {
            return new ListWafLogsResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListWafLogsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

