/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.WafRequest;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWafRequestsResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<WafRequest> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListWafRequestsResponse(String opcRequestId, String opcNextPage, List<WafRequest> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<WafRequest> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<WafRequest> items;

        public Builder copy(ListWafRequestsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<WafRequest> items) {
            this.items = items;
            return this;
        }

        public ListWafRequestsResponse build() {
            return new ListWafRequestsResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListWafRequestsResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

