/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.WafTrafficDatum;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWafTrafficResponse {
    private String opcRequestId;
    private String opcNextPage;
    private List<WafTrafficDatum> items;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "items"})
    ListWafTrafficResponse(String opcRequestId, String opcNextPage, List<WafTrafficDatum> items) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<WafTrafficDatum> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private List<WafTrafficDatum> items;

        public Builder copy(ListWafTrafficResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<WafTrafficDatum> items) {
            this.items = items;
            return this;
        }

        public ListWafTrafficResponse build() {
            return new ListWafTrafficResponse(this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListWafTrafficResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

