/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.Whitelist;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWhitelistsResponse {
    private String etag;
    private String opcRequestId;
    private String opcNextPage;
    private List<Whitelist> items;

    @ConstructorProperties(value={"etag", "opcRequestId", "opcNextPage", "items"})
    ListWhitelistsResponse(String etag, String opcRequestId, String opcNextPage, List<Whitelist> items) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public List<Whitelist> getItems() {
        return this.items;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private String opcNextPage;
        private List<Whitelist> items;

        public Builder copy(ListWhitelistsResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder items(List<Whitelist> items) {
            this.items = items;
            return this;
        }

        public ListWhitelistsResponse build() {
            return new ListWhitelistsResponse(this.etag, this.opcRequestId, this.opcNextPage, this.items);
        }

        public String toString() {
            return "ListWhitelistsResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", items=" + this.items + ")";
        }
    }
}

