/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.AddressList;
import java.beans.ConstructorProperties;

public class UpdateAddressListResponse {
    private String opcRequestId;
    private String etag;
    private AddressList addressList;

    @ConstructorProperties(value={"opcRequestId", "etag", "addressList"})
    UpdateAddressListResponse(String opcRequestId, String etag, AddressList addressList) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.addressList = addressList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public AddressList getAddressList() {
        return this.addressList;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private AddressList addressList;

        public Builder copy(UpdateAddressListResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.addressList(o.getAddressList());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder addressList(AddressList addressList) {
            this.addressList = addressList;
            return this;
        }

        public UpdateAddressListResponse build() {
            return new UpdateAddressListResponse(this.opcRequestId, this.etag, this.addressList);
        }

        public String toString() {
            return "UpdateAddressListResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", addressList=" + this.addressList + ")";
        }
    }
}

