/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.responses;

import com.oracle.bmc.waas.model.Certificate;
import java.beans.ConstructorProperties;

public class UpdateCertificateResponse {
    private String opcRequestId;
    private String etag;
    private Certificate certificate;

    @ConstructorProperties(value={"opcRequestId", "etag", "certificate"})
    UpdateCertificateResponse(String opcRequestId, String etag, Certificate certificate) {
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.certificate = certificate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public static class Builder {
        private String opcRequestId;
        private String etag;
        private Certificate certificate;

        public Builder copy(UpdateCertificateResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.certificate(o.getCertificate());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder certificate(Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public UpdateCertificateResponse build() {
            return new UpdateCertificateResponse(this.opcRequestId, this.etag, this.certificate);
        }

        public String toString() {
            return "UpdateCertificateResponse.Builder(opcRequestId=" + this.opcRequestId + ", etag=" + this.etag + ", certificate=" + this.certificate + ")";
        }
    }
}

