/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.workrequests;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import com.oracle.bmc.workrequests.responses.GetWorkRequestResponse;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutorService;

public class WorkRequestWaiters {
    private final ExecutorService executorService;
    private final WorkRequest client;

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter(terminationStrategy, delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl<GetWorkRequestRequest, GetWorkRequestResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return WorkRequestWaiters.this.client.getWorkRequest(request);
            }
        }, new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public WorkRequestWaiters(ExecutorService executorService, WorkRequest client) {
        this.executorService = executorService;
        this.client = client;
    }
}

