/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.soa.plugin;

import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import com.oracle.soa.plugin.CompositeDeployerClientFactory;
import java.io.IOException;
import java.net.URL;
import javax.xml.bind.JAXBException;
import oracle.integration.platform.blocks.deploy.servlet.CompositeDeployerClient;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Settings;

public abstract class AbstractDeploymentHandlerMojo
extends AbstractMojo {
    private static final int HTTP_OK = 200;
    @Parameter(property="serverURL", required=true)
    protected String serverUrl;
    @Deprecated
    @Parameter(property="partition", defaultValue="default")
    protected String partition;
    @Parameter(property="folder", defaultValue="default")
    protected String folder;
    @Parameter(property="user")
    protected String user;
    @Parameter(property="password")
    protected String password;
    @Parameter(property="settingsXmlServerId", alias="serverId")
    protected String settingsXmlServerId;
    @Component
    protected WagonManager wagonManager;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    protected final String realm = "default";
    private CompositeDeployerClientFactory clientFactory;

    public void execute() throws MojoExecutionException {
        this.logPluginInfo();
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skip flag = true, skipping execute");
            return;
        }
        if ("default".equals(this.folder)) {
            this.folder = this.partition;
        }
        try {
            CompositeDeployerClient client = this.getClientFactory().createClient(new URL(this.serverUrl));
            this.authenticateClient(client);
            this.configureClient(client);
            this.performRequest(client);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    void setClientFactory(CompositeDeployerClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    private CompositeDeployerClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new CompositeDeployerClientFactory();
        }
        return this.clientFactory;
    }

    protected void performRequest(CompositeDeployerClient client) throws IOException, ModuleException, JAXBException, ParseException, MojoExecutionException {
        int respCode = client.sendRequest();
        if (respCode != 200) {
            String message = "---->response code=" + respCode + ", error:" + client.getErrorMsg();
            System.out.println(message);
            throw new MojoExecutionException(message);
        }
        System.out.println("---->" + this.getPluginActionName() + "ing composite success.");
    }

    protected void logPluginInfo() {
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)("ORACLE SOA MAVEN PLUGIN - " + this.getPluginActionName().toUpperCase() + " COMPOSITE"));
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"");
    }

    protected abstract String getPluginActionName();

    protected abstract void configureClient(CompositeDeployerClient var1);

    protected void authenticateClient(CompositeDeployerClient client) throws MojoExecutionException {
        this.getLog().info((CharSequence)("setting user/password..., user=" + this.user));
        client.setBasicAuth("default", this.user, this.password);
    }

    protected boolean isSet(String field) {
        return field != null && !"".equals(field) && field.length() >= 1;
    }

    protected abstract boolean isSkip();
}

