/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.soa.plugin;

import com.oracle.soa.plugin.SarArchiver;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;

public abstract class AbstractSarMojo
extends AbstractMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/package.html"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    private static final String[] standardIncludes = new String[]{"**/*"};
    private static final String[] standardExcludes = new String[]{"classes/**", "deploy/**", "dist/**", ".designer/**", "**/*.jpr", "**/*.ear", "**/*.zip", "**/*.war", "**/*.jws", "**/.ade_path/**", "**/scac.log", "**/scac_out.xml", "**/*.sar"};
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File outputDirectory;
    @Parameter(property="sarName", defaultValue="${project.build.finalName}")
    protected String finalName;
    @Component(role=Archiver.class, hint="sar")
    protected SarArchiver sarArchiver;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter
    protected MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", required=true, readonly=true)
    protected File defaultManifestFile;
    @Parameter(property="sar.useDefaultManifestFile", defaultValue="false")
    protected boolean useDefaultManifestFile;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(property="sar.forceCreation", defaultValue="false")
    protected boolean forceCreation;
    @Parameter(property="sar.skipIfEmpty", defaultValue="false")
    protected boolean skipIfEmpty;

    protected abstract File getContentDirectory();

    protected abstract MavenProject getProject();

    protected abstract String getClassifier();

    protected abstract String getType();

    protected File getDefaultManifestFile() {
        return this.defaultManifestFile;
    }

    protected String[] getIncludes() {
        ArrayList<String> ex = new ArrayList<String>(Arrays.asList(standardIncludes));
        if (this.includes != null && this.includes.length > 0) {
            ex.addAll(Arrays.asList(this.includes));
        } else {
            ex.addAll(Arrays.asList(DEFAULT_INCLUDES));
        }
        String[] exArray = new String[1];
        return ex.toArray(exArray);
    }

    protected String[] getExcludes() {
        ArrayList<String> ex = new ArrayList<String>(Arrays.asList(standardExcludes));
        if (this.excludes != null && this.excludes.length > 0) {
            ex.addAll(Arrays.asList(this.excludes));
        } else {
            ex.addAll(Arrays.asList(DEFAULT_EXCLUDES));
        }
        String[] exArray = new String[1];
        return ex.toArray(exArray);
    }
}

