/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.soa.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class ProcessHandler {
    private static final String CRLF = System.getProperty("line.separator");
    private static final long POLL_INTERVAL = 1000L;
    private ProcessBuilder procBuilder;
    private Process process;
    private Log mvnLog;
    private File logFile;
    private Thread drainerThread;
    private int timeout = -1;
    private WaitHandler waitHandler;
    private boolean bufferProcessLog;
    private StringBuffer processLog = new StringBuffer();

    public ProcessHandler(String[] cmd, File workingDir, boolean bufferProcessLog) {
        this.procBuilder = new ProcessBuilder(new String[0]);
        this.procBuilder.command(cmd);
        this.procBuilder.directory(workingDir);
        this.procBuilder.redirectErrorStream(true);
        this.bufferProcessLog = bufferProcessLog;
    }

    public String getProcessLog() {
        return this.processLog.toString();
    }

    public void setStdoutLog(File log) {
        this.logFile = log;
    }

    public void setMavenLog(Log mvnLog) {
        this.mvnLog = mvnLog;
    }

    public void setTimeoutSecs(int timeout) {
        this.timeout = timeout * 1000;
    }

    public void registerWaitHandler(WaitHandler handler) {
        this.waitHandler = handler;
    }

    public void clearEnv() {
        this.procBuilder.environment().clear();
    }

    public boolean setEnvIfNotSet(String name, String value) {
        Map<String, String> env = this.procBuilder.environment();
        if (env.get(name) != null) {
            return false;
        }
        env.put(name, value);
        return true;
    }

    public void setEnv(String name, String value) {
        this.procBuilder.environment().put(name, value);
    }

    public void exec() throws IOException {
        if (this.waitHandler == null) {
            throw new IOException("No wait handler registered");
        }
        this.drainerThread = new Thread(new DrainerThread());
        this.drainerThread.setDaemon(true);
        long beginTime = System.currentTimeMillis();
        this.mvnLog.info((CharSequence)"Process being executed, waiting for completion.");
        if (this.bufferProcessLog) {
            this.mvnLog.info((CharSequence)"Process log is being buffered and will only be shown if there is an error executing the process.  If you want to see the logs as the process is run then pass -DshowProcessLog=true");
        }
        this.process = this.procBuilder.start();
        this.drainerThread.start();
        try {
            long elapsed;
            do {
                if (this.waitHandler.isWaitComplete()) {
                    return;
                }
                if (!this.isRunning()) {
                    this.waitHandler.processExit(this.process);
                    return;
                }
                Thread.sleep(1000L);
                elapsed = System.currentTimeMillis() - beginTime;
            } while (this.timeout <= 0 || elapsed <= (long)this.timeout);
            this.mvnLog.error((CharSequence)"Timeout elapsed for process");
            if (!this.waitHandler.processTimeout(this.process)) {
                this.process.destroy();
                throw new IOException("Timeout waiting for process");
            }
            return;
        }
        catch (InterruptedException e) {
            this.mvnLog.error((CharSequence)"Error on the polling thread", (Throwable)e);
            return;
        }
    }

    public boolean isRunning() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException ignore) {
            return true;
        }
    }

    public int getStatusCode() {
        return this.process.exitValue();
    }

    public void kill() {
        this.process.destroy();
    }

    public String toString() {
        return "[cmd:" + this.procBuilder.command() + "]";
    }

    public static interface WaitHandler {
        public boolean isWaitComplete();

        public boolean processTimeout(Process var1);

        public void processExit(Process var1);
    }

    public class DrainerThread
    implements Runnable {
        public void run() {
            InputStream is = ProcessHandler.this.process.getInputStream();
            try {
                String msg;
                FileWriter writer = ProcessHandler.this.logFile == null ? null : new FileWriter(ProcessHandler.this.logFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                while ((msg = reader.readLine()) != null) {
                    if (writer != null) {
                        writer.write(msg);
                        writer.write(CRLF);
                        ((Writer)writer).flush();
                        continue;
                    }
                    String tmpMsg = "[exec] " + msg;
                    if (!ProcessHandler.this.bufferProcessLog) {
                        ProcessHandler.this.mvnLog.info((CharSequence)tmpMsg);
                        continue;
                    }
                    ProcessHandler.this.processLog.append(tmpMsg);
                    ProcessHandler.this.processLog.append(CRLF);
                }
            }
            catch (Exception e) {
                ProcessHandler.this.mvnLog.error((Throwable)e);
            }
        }
    }
}

