/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.soa.plugin;

import com.oracle.soa.plugin.AbstractSarMojo;
import com.oracle.soa.plugin.ProcessHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresProject=true, threadSafe=true)
public class SarCompileMojo
extends AbstractSarMojo {
    protected static final boolean OS_WIN = File.separatorChar == '\\';
    @Parameter(property="showProcessLog", defaultValue="false")
    private boolean showProcessLog;
    @Parameter(property="composite")
    private String composite;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="${scac.input.dir}", required=true)
    private File scacInputDir;
    @Parameter(property="ignoreErrors", defaultValue="false")
    private boolean ignoreErrors;
    @Parameter(property="level", defaultValue="1")
    private int level;
    @Parameter(property="xml")
    private String xml;
    @Parameter(property="noComponents", defaultValue="false")
    private boolean noComponents;
    @Parameter(property="appHome")
    private String appHome;
    @Parameter(property="oracleHome", alias="oracle.home")
    private String oracleHome;
    @Parameter(property="soaOracleHome", alias="soa.oracle.home")
    private String soaOracleHome;
    @Parameter(property="commonComponentsHome")
    private String commonComponentsHome;
    @Parameter(property="failOnWarning", defaultValue="false")
    private boolean failOnWarning;
    @Parameter(property="reportErrors", defaultValue="false")
    private boolean reportErrors;
    @Parameter(defaultValue="${plugin.artifacts}")
    private List pluginArtifacts;
    @Parameter(property="http.nonProxyHosts", alias="http.nonProxyHosts")
    private String httpNonProxyHosts;
    @Parameter(property="http.proxyHost", alias="http.proxyHost")
    private String httpProxyHost;
    @Parameter(property="http.proxyPort", alias="http.proxyPort")
    private Integer httpProxyPort;
    @Parameter(property="https.proxyHost", alias="https.proxyHost")
    private String httpsProxyHost;
    @Parameter(property="https.proxyPort", alias="https.proxyPort")
    private Integer httpsProxyPort;
    @Parameter(property="soamds.apps.home", alias="soamds.apps.home")
    private String soaMdsAppsHome;
    @Parameter(property="javax.net.ssl.trustStore", alias="javax.net.ssl.trustStore")
    private String trustStore;
    @Parameter(property="javaExtraProperties")
    private String javaExtraProperties;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="soa.compile.skip", defaultValue="false")
    private boolean skip;

    @Override
    protected String getClassifier() {
        return this.classifier;
    }

    @Override
    protected String getType() {
        return "sar";
    }

    protected File getClassesDirectory() {
        return this.classesDirectory;
    }

    protected boolean isSkip() {
        return this.skip;
    }

    @Override
    protected File getContentDirectory() {
        return this.scacInputDir;
    }

    @Override
    protected MavenProject getProject() {
        return this.project;
    }

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"ORACLE SOA MAVEN PLUGIN - COMPILE");
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"");
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skip flag = true, skipping sar compiling");
            return;
        }
        this.getLog().info((CharSequence)"ABOUT TO RUN oracle.soa.scac.ValidateComposite...");
        try {
            ArrayList<String> cpel = new ArrayList<String>();
            for (Object arto : this.pluginArtifacts) {
                Artifact dep = (Artifact)arto;
                if (!dep.getScope().equals("compile") && !dep.getScope().equals("runtime")) continue;
                cpel.add(dep.getFile().getAbsolutePath());
            }
            StringBuffer cpBuffer = new StringBuffer();
            for (String cpentry : cpel) {
                cpBuffer.append(cpentry).append(File.pathSeparator);
            }
            ArrayList<String> myargs = new ArrayList<String>();
            StringBuffer javaExec = new StringBuffer();
            if (System.getenv().get("JAVA_HOME") != null) {
                javaExec.append(System.getenv().get("JAVA_HOME").trim());
            } else if (System.getProperty("java.home") != null) {
                javaExec.append(System.getProperty("java.home").trim());
            }
            if (javaExec.length() > 0) {
                if (!javaExec.toString().endsWith(File.separator)) {
                    javaExec.append(File.separator);
                }
                javaExec.append("bin" + File.separator + "java");
            } else {
                javaExec.append("java");
            }
            myargs.add(javaExec.toString());
            this.setProxyInfo(myargs);
            if (this.soaMdsAppsHome != null) {
                this.getLog().debug((CharSequence)("Setting soamds.apps.home=" + this.soaMdsAppsHome));
                myargs.add("-Dsoamds.apps.home=" + this.soaMdsAppsHome);
            } else {
                this.getLog().debug((CharSequence)"soamds.apps.home not set!");
            }
            if (this.trustStore != null) {
                this.getLog().debug((CharSequence)("Setting javax.net.ssl.trustStore=" + this.trustStore));
                myargs.add("-Djavax.net.ssl.trustStore=" + this.trustStore);
            } else {
                this.getLog().debug((CharSequence)"javax.net.ssl.trustStore not set!");
            }
            if (this.javaExtraProperties != null) {
                this.getLog().debug((CharSequence)("Setting javaExtraProperties=" + this.javaExtraProperties));
                Pattern p = Pattern.compile("[^\\s]*\"[^\"]*\"[^\\s]*|[^\\s]*'[^']*'[^\\s]*|[^\\s\\\"']+");
                Matcher m = p.matcher(this.javaExtraProperties);
                while (m.find()) {
                    String javaExtraProperty = m.group();
                    myargs.add(javaExtraProperty);
                }
            } else {
                this.getLog().debug((CharSequence)"javaExtraProperties not set!");
            }
            myargs.add("-Djava.protocol.handler.pkgs=oracle.mds.net.protocol|oracle.fabric.common.classloaderurl.handler|oracle.fabric.common.uddiurl.handler");
            if (this.oracleHome != null && !"".equals(this.oracleHome) && this.oracleHome.length() >= 1) {
                myargs.add("-Doracle.home=" + this.oracleHome);
            } else {
                this.getLog().info((CharSequence)"The environment variable/property 'oracle.home' is not set.");
            }
            if (this.commonComponentsHome != null && !"".equals(this.commonComponentsHome) && this.commonComponentsHome.length() >= 1) {
                myargs.add("-Dcommon.components.home=" + this.commonComponentsHome);
            } else {
                this.getLog().info((CharSequence)"The environment variable/property 'common.components.home' is not set.");
            }
            if (this.soaOracleHome != null && !"".equals(this.soaOracleHome) && this.soaOracleHome.length() >= 1) {
                myargs.add("-Dsoa.oracle.home=" + this.soaOracleHome);
            } else {
                this.getLog().info((CharSequence)"The environment variable/property 'soa.oracle.home' is not set.");
            }
            myargs.add("oracle.soa.scac.ValidateComposite");
            myargs.add(this.composite);
            if (this.ignoreErrors) {
                myargs.add("-ignoreErrors");
            }
            myargs.add("-level=" + this.level);
            if (this.xml != null && !"".equals(this.xml) && this.xml.length() >= 1) {
                myargs.add("-xml=" + this.xml);
            }
            if (this.noComponents) {
                myargs.add("-noComponents");
            }
            if (this.appHome != null && !"".equals(this.appHome) && this.appHome.length() >= 1) {
                myargs.add("-appHome=" + this.appHome);
            }
            if (this.failOnWarning) {
                myargs.add("-failOnWarning");
            }
            if (this.reportErrors) {
                myargs.add("-reportErrors=true");
            }
            File dir = this.getProject().getBasedir();
            String[] cmd = myargs.toArray(new String[myargs.size()]);
            ProcessHandler procHandler = new ProcessHandler(cmd, dir, !this.showProcessLog);
            procHandler.setEnv("CLASSPATH", cpBuffer.toString());
            procHandler.setMavenLog(this.getLog());
            procHandler.setEnvIfNotSet("JAVA_HOME", System.getProperty("java.home"));
            if (this.soaOracleHome != null && !"".equals(this.soaOracleHome) && this.soaOracleHome.length() >= 1 && this.oracleHome != null && !"".equals(this.oracleHome) && this.oracleHome.length() >= 1) {
                procHandler.setEnvIfNotSet("soa.oracle.home", this.soaOracleHome);
                procHandler.setEnvIfNotSet("oracle.home", this.oracleHome);
            } else {
                this.getLog().info((CharSequence)"The environment variable/property 'oracle.home' or 'soa.oracle.home is not set.");
                this.getLog().info((CharSequence)"If you want to compile a composite with a component that depends\non MDS - like a Human Task or Business Rule - AND you want to use a file\nbased MDS repository, you will need to specify 'oracle.home' AND 'soa.oracle.home' OR update\nyour .adf/META-INF/adf-config.xml to point to your file-based MDS.\nIf you specify oracle.home it must point to the SOA Quickstart or \nJDeveloper install directory with '/soa' appended to it, unless you\nupdate the adf-config.xml to remove the reference to oracle.home.");
            }
            procHandler.registerWaitHandler(new ProcessHandler.WaitHandler(){

                public boolean isWaitComplete() {
                    return false;
                }

                public boolean processTimeout(Process process) {
                    return false;
                }

                public void processExit(Process process) {
                }
            });
            this.getLog().info((CharSequence)("compile: Executing: " + procHandler));
            procHandler.exec();
            int result = procHandler.getStatusCode();
            this.getLog().info((CharSequence)("compile: " + procHandler + " exit code=" + result));
            if (result != 0) {
                if (!this.showProcessLog) {
                    this.getLog().info((CharSequence)"processLog: ------------------------------------- ");
                    this.getLog().info((CharSequence)procHandler.getProcessLog());
                }
                throw new MojoExecutionException("SOA COMPILE FAILED with value: " + result);
            }
        }
        catch (MojoExecutionException me) {
            throw me;
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("SOA COMPILE failed with value: " + ioe.getMessage(), (Exception)ioe);
        }
        this.getLog().info((CharSequence)"SOA COMPILE DONE");
    }

    private void setProxyInfo(List<String> myargs) {
        String httpsProxyPortS;
        String httpProxyPortS;
        Proxy activeProxy = this.settings != null ? this.settings.getActiveProxy() : null;
        this.getLog().debug((CharSequence)("settings = " + this.settings));
        this.getLog().debug((CharSequence)("settings.getActiveProxy() = " + activeProxy));
        if (this.httpProxyHost != null) {
            this.getLog().debug((CharSequence)"Setting http.proxyHost from Maven config property \"http.proxyHost\"");
        } else if (System.getProperties().contains("http.proxyHost")) {
            this.getLog().debug((CharSequence)"Setting http.proxyHost from system property \"http.proxyHost\"");
            this.httpProxyHost = System.getProperty("http.proxyHost");
        } else if (System.getenv().containsKey("HTTP_PROXY_HOST")) {
            this.getLog().debug((CharSequence)"Setting http.proxyHost from environment variable \"HTTP_PROXY_HOST\"");
            this.httpProxyHost = System.getenv("HTTP_PROXY_HOST");
        } else if (activeProxy != null) {
            this.getLog().debug((CharSequence)("Setting http.proxyHost from pom.xml / settings.xml proxy \"" + activeProxy.getId() + "\""));
            this.httpProxyHost = activeProxy.getHost();
        }
        if (this.httpProxyHost != null && !this.httpProxyHost.isEmpty() && !"null".equalsIgnoreCase(this.httpProxyHost)) {
            this.getLog().debug((CharSequence)("Setting http.proxyHost=" + this.httpProxyHost));
            myargs.add("-Dhttp.proxyHost=" + this.httpProxyHost);
        } else {
            this.getLog().debug((CharSequence)"http.proxyHost not set!");
        }
        if (this.httpProxyPort != null) {
            this.getLog().debug((CharSequence)"Setting http.proxyPort from Maven config property \"http.proxyPort\"");
            httpProxyPortS = Integer.toString(this.httpProxyPort);
        } else if (System.getProperties().contains("http.proxyPort")) {
            this.getLog().debug((CharSequence)"Setting http.proxyPort from system property \"http.proxyPort\"");
            httpProxyPortS = System.getProperty("http.proxyPort");
        } else if (System.getenv().containsKey("HTTP_PROXY_PORT")) {
            this.getLog().debug((CharSequence)"Setting http.proxyPort from environment variable \"HTTP_PROXY_PORT\"");
            httpProxyPortS = System.getenv("HTTP_PROXY_PORT");
        } else if (activeProxy != null) {
            this.getLog().debug((CharSequence)("Setting http.proxyPort from pom.xml / settings.xml proxy \"" + activeProxy.getId() + "\""));
            httpProxyPortS = Integer.toString(activeProxy.getPort());
        } else {
            httpProxyPortS = null;
        }
        if (httpProxyPortS != null && !httpProxyPortS.isEmpty() && !"-1".equalsIgnoreCase(httpProxyPortS)) {
            this.getLog().debug((CharSequence)("Setting http.proxyPort=" + httpProxyPortS));
            myargs.add("-Dhttp.proxyPort=" + httpProxyPortS);
        } else {
            this.getLog().debug((CharSequence)"http.proxyPort not set!");
        }
        if (this.httpsProxyHost != null) {
            this.getLog().debug((CharSequence)"Setting https.proxyHost from Maven config property \"https.proxyHost\"");
        } else if (System.getProperties().contains("https.proxyHost")) {
            this.getLog().debug((CharSequence)"Setting https.proxyHost from system property \"https.proxyHost\"");
            this.httpsProxyHost = System.getProperty("https.proxyHost");
        } else if (System.getenv().containsKey("HTTPS_PROXY_HOST")) {
            this.getLog().debug((CharSequence)"Setting https.proxyHost from environment variable \"HTTPS_PROXY_HOST\"");
            this.httpsProxyHost = System.getenv("HTTPS_PROXY_HOST");
        } else if (activeProxy != null) {
            this.getLog().debug((CharSequence)("Setting https.proxyHost from pom.xml / settings.xml proxy \"" + activeProxy.getId() + "\""));
            this.httpsProxyHost = activeProxy.getHost();
        }
        if (this.httpsProxyHost != null && !this.httpsProxyHost.isEmpty() && !"null".equalsIgnoreCase(this.httpsProxyHost)) {
            this.getLog().debug((CharSequence)("Setting https.proxyHost=" + this.httpsProxyHost));
            myargs.add("-Dhttps.proxyHost=" + this.httpsProxyHost);
        } else {
            this.getLog().debug((CharSequence)"https.proxyHost not set!");
        }
        if (this.httpsProxyPort != null) {
            this.getLog().debug((CharSequence)"Setting https.proxyPort from Maven config property \"https.proxyPort\"");
            httpsProxyPortS = Integer.toString(this.httpsProxyPort);
        } else if (System.getProperties().contains("https.proxyPort")) {
            this.getLog().debug((CharSequence)"Setting https.proxyPort from system property \"https.proxyPort\"");
            httpsProxyPortS = System.getProperty("https.proxyPort");
        } else if (System.getenv().containsKey("HTTPS_PROXY_PORT")) {
            this.getLog().debug((CharSequence)"Setting https.proxyPort from environment variable \"HTTPS_PROXY_PORT\"");
            httpsProxyPortS = System.getenv("HTTPS_PROXY_PORT");
        } else if (activeProxy != null) {
            this.getLog().debug((CharSequence)("Setting https.proxyPort from pom.xml / settings.xml proxy \"" + activeProxy.getId() + "\""));
            httpsProxyPortS = Integer.toString(activeProxy.getPort());
        } else {
            httpsProxyPortS = null;
        }
        if (httpsProxyPortS != null && !httpsProxyPortS.isEmpty() && !"-1".equalsIgnoreCase(httpsProxyPortS)) {
            this.getLog().debug((CharSequence)("Setting https.proxyPort=" + httpsProxyPortS));
            myargs.add("-Dhttps.proxyPort=" + httpsProxyPortS);
        } else {
            this.getLog().debug((CharSequence)"https.proxyPort not set!");
        }
        if (this.httpNonProxyHosts != null) {
            this.getLog().debug((CharSequence)"Setting http.nonProxyHosts from Maven config property \"http.nonProxyHosts\"");
        } else if (System.getProperties().contains("http.nonProxyHosts")) {
            this.getLog().debug((CharSequence)"Setting http.nonProxyHosts from system property \"http.nonProxyHosts\"");
            this.httpNonProxyHosts = System.getProperty("http.nonProxyHosts");
        } else if (System.getenv().containsKey("NO_PROXY")) {
            this.getLog().debug((CharSequence)"Setting http.nonProxyHosts from environment variable \"NO_PROXY\"");
            this.httpNonProxyHosts = System.getenv("NO_PROXY");
        } else if (activeProxy != null) {
            this.getLog().debug((CharSequence)("Setting http.nonProxyHosts from pom.xml / settings.xml proxy \"" + activeProxy.getId() + "\""));
            this.httpNonProxyHosts = activeProxy.getNonProxyHosts();
        }
        if (this.httpNonProxyHosts != null && !this.httpNonProxyHosts.isEmpty() && !"null".equalsIgnoreCase(this.httpNonProxyHosts)) {
            this.getLog().debug((CharSequence)("Setting http.nonProxyHosts=" + this.httpNonProxyHosts));
            myargs.add("-Dhttp.nonProxyHosts=" + this.httpNonProxyHosts);
        } else {
            this.getLog().debug((CharSequence)"http.nonProxyHosts not set!");
        }
    }
}

