/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.soa.plugin;

import com.oracle.soa.plugin.AbstractSarMojo;
import java.io.File;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, name="sar", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class SarPackageMojo
extends AbstractSarMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="${scac.input.dir}", required=true)
    private File scacInputDir;
    @Parameter(property="soa.package.skip", defaultValue="false")
    private boolean skip;

    protected boolean isSkip() {
        return this.skip;
    }

    public void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skip flag = true, skipping sar packaging");
            return;
        }
        if (this.skipIfEmpty && !this.getContentDirectory().exists()) {
            this.getLog().info((CharSequence)"Skipping packaging of the test-sar");
        } else {
            File sarFile = this.createArchive();
            String classifier = this.getClassifier();
            if (classifier != null) {
                this.projectHelper.attachArtifact(this.getProject(), this.getType(), classifier, sarFile);
            } else {
                this.getProject().getArtifact().setFile(sarFile);
            }
        }
    }

    public File createArchive() throws MojoExecutionException {
        File sarFile = SarPackageMojo.getSarFile(this.outputDirectory, this.getProject().getArtifactId(), this.getProject().getVersion());
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.sarArchiver);
        archiver.setOutputFile(sarFile);
        this.archive.setForced(this.forceCreation);
        try {
            File contentDirectory = this.getContentDirectory();
            if (!contentDirectory.exists()) {
                this.getLog().warn((CharSequence)"SAR will be empty - no content was marked for inclusion!");
            } else {
                archiver.getArchiver().addDirectory(contentDirectory, this.getIncludes(), this.getExcludes());
            }
            File existingManifest = this.getDefaultManifestFile();
            if (this.useDefaultManifestFile && existingManifest.exists() && this.archive.getManifestFile() == null) {
                this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + existingManifest.getPath()));
                this.archive.setManifestFile(existingManifest);
            }
            if (sarFile.exists()) {
                sarFile.delete();
            }
            archiver.createArchive(this.session, this.getProject(), this.archive);
            return sarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling SAR", e);
        }
    }

    protected String getClassifier() {
        return this.classifier;
    }

    protected static File getSarFile(File basedir, String name, String revision) {
        return new File(basedir, "sca_" + name + "_rev" + revision + ".jar");
    }

    protected String getType() {
        return "sar";
    }

    protected File getClassesDirectory() {
        return this.classesDirectory;
    }

    protected File getContentDirectory() {
        return this.scacInputDir;
    }

    protected MavenProject getProject() {
        return this.project;
    }
}

