/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.soa.plugin;

import com.oracle.soa.plugin.AbstractDeploymentHandlerMojo;
import oracle.integration.platform.blocks.deploy.servlet.CompositeDeployerClient;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

@Mojo(name="deploy")
public class SoaDeploy
extends AbstractDeploymentHandlerMojo {
    @Parameter(property="sarLocation")
    String sarLocation;
    @Parameter(property="keepInstancesOnRedeploy", defaultValue="false")
    boolean keepInstancesOnRedeploy;
    @Parameter(property="overwrite", defaultValue="false")
    boolean overwrite;
    @Parameter(property="forceDefault", defaultValue="true")
    boolean forceDefault;
    @Parameter(property="configplan")
    String configplan;
    @Parameter(property="regenerateRuldBase", defaultValue="false")
    boolean regenerateRuleBase = false;
    @Parameter(property="timeout", defaultValue="-1")
    int timeout;
    @Parameter(property="soa.deploy.skip", defaultValue="false")
    private boolean skip;

    protected void configureClient(CompositeDeployerClient client) {
        client.setFolder(this.folder);
        client.setOverwrite(this.overwrite);
        client.setForceDefault(this.forceDefault);
        client.setKeepInstancesOnRedeploy(this.keepInstancesOnRedeploy);
        client.setRegenerateRuleBase(this.regenerateRuleBase);
        client.setCommand("deploy");
        if (this.configplan != null) {
            client.setDeployPlan(this.configplan);
        }
        if (this.sarLocation.endsWith(".ear")) {
            client.setEar(this.sarLocation);
        } else {
            client.setSar(this.sarLocation);
        }
        if (this.timeout != -1) {
            client.setTimeout(this.timeout);
        }
        this.setProxyInfo();
    }

    protected void authenticateClient(CompositeDeployerClient client) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Entering authenticateClient");
        if (this.settings == null) {
            this.getLog().debug((CharSequence)"settings is null");
        } else if (this.settingsXmlServerId == null) {
            this.getLog().debug((CharSequence)"settingsXmlServerId is null");
        } else {
            this.getLog().debug((CharSequence)"Property \"settingsXmlServerId\"/\"serverId\" is set.  Getting username / password from settings.xml . . .");
            Server server = this.settings.getServer(this.settingsXmlServerId);
            if (server == null) {
                this.getLog().warn((CharSequence)("Property \"settingsXmlServerId\"/\"serverId\" is set but cannot find corresponding server with id \"" + this.settingsXmlServerId + "\" in settings.xml"));
            } else {
                if (this.isSet(this.user)) {
                    this.getLog().warn((CharSequence)"Both \"user\" and \"settingsXmlServerId\"/\"serverId\" properties are set!  The value of the \"user\" property will override the value from settings.xml");
                } else if (!this.isSet(server.getUsername())) {
                    this.getLog().warn((CharSequence)("Property \"settingsXmlServerId\"/\"serverId\" is set but there is no username value in settings.xml for the server with id \"" + this.settingsXmlServerId + "\""));
                } else {
                    this.getLog().debug((CharSequence)("server[" + this.settingsXmlServerId + "].getUsername() = " + server.getUsername()));
                    this.user = server.getUsername();
                }
                if (this.isSet(this.password)) {
                    this.getLog().warn((CharSequence)"Both \"password\" and \"settingsXmlServerId\"/\"serverId\" properties are set!  The value of the \"password\" property will override the value from settings.xml");
                } else if (!this.isSet(server.getPassword())) {
                    this.getLog().warn((CharSequence)("Property \"settingsXmlServerId\"/\"serverId\" is set but there is no password value in settings.xml for the server with id \"" + this.settingsXmlServerId + "\""));
                } else {
                    AuthenticationInfo authInfo = this.wagonManager.getAuthenticationInfo(this.settingsXmlServerId);
                    if (authInfo == null) {
                        this.getLog().warn((CharSequence)("Failed to decrypt server with id \"" + this.settingsXmlServerId + "\""));
                    } else {
                        this.getLog().debug((CharSequence)("server[" + this.settingsXmlServerId + "].getPassword() = *****************"));
                        this.password = authInfo.getPassword();
                    }
                }
            }
        }
        if (!this.isSet(this.user) || !this.isSet(this.password)) {
            this.getLog().error((CharSequence)"You must specify the user and password to use the deploy goal.");
            throw new MojoExecutionException("user and/or password properties missing");
        }
        super.authenticateClient(client);
    }

    protected String getPluginActionName() {
        return "Deploy";
    }

    protected boolean isSkip() {
        return this.skip;
    }

    private void setProxyInfo() {
        Proxy activeProxy = this.settings != null ? this.settings.getActiveProxy() : null;
        String httpProxyHost = System.getProperty("http.proxyHost");
        if (httpProxyHost != null) {
            this.getLog().debug((CharSequence)"Setting http.proxyHost from system property \"http.proxyHost\"");
        } else if (System.getenv().containsKey("HTTP_PROXY_HOST")) {
            this.getLog().debug((CharSequence)"Setting http.proxyHost from environment variable \"HTTP_PROXY_HOST\"");
            httpProxyHost = System.getenv("HTTP_PROXY_HOST");
        } else if (activeProxy != null) {
            this.getLog().debug((CharSequence)("Setting http.proxyHost from pom.xml / settings.xml proxy \"" + activeProxy.getId() + "\""));
            httpProxyHost = activeProxy.getHost();
        }
        if (httpProxyHost != null && !httpProxyHost.isEmpty() && !"null".equalsIgnoreCase(httpProxyHost)) {
            this.getLog().debug((CharSequence)("Setting http.proxyHost=" + httpProxyHost));
            System.setProperty("http.proxyHost", httpProxyHost);
        } else {
            this.getLog().debug((CharSequence)"http.proxyHost not set!");
            System.clearProperty("http.proxyHost");
        }
        String httpProxyPort = System.getProperty("http.proxyPort");
        if (httpProxyPort != null) {
            this.getLog().debug((CharSequence)"Setting http.proxyPort from system property \"http.proxyPort\"");
        } else if (System.getenv().containsKey("HTTP_PROXY_PORT")) {
            this.getLog().debug((CharSequence)"Setting http.proxyPort from environment variable \"HTTP_PROXY_PORT\"");
            httpProxyPort = System.getenv("HTTP_PROXY_PORT");
        } else if (activeProxy != null) {
            this.getLog().debug((CharSequence)("Setting http.proxyPort from pom.xml / settings.xml proxy \"" + activeProxy.getId() + "\""));
            httpProxyPort = Integer.toString(activeProxy.getPort());
        }
        if (httpProxyPort != null && !httpProxyPort.isEmpty() && !"-1".equalsIgnoreCase(httpProxyPort)) {
            this.getLog().debug((CharSequence)("Setting http.proxyPort=" + httpProxyPort));
            System.setProperty("http.proxyPort", httpProxyPort);
        } else {
            this.getLog().debug((CharSequence)"http.proxyPort not set!");
            System.clearProperty("http.proxyPort");
        }
        String httpsProxyHost = System.getProperty("https.proxyHost");
        if (httpsProxyHost != null) {
            this.getLog().debug((CharSequence)"Setting https.proxyHost from system property \"https.proxyHost\"");
        } else if (System.getenv().containsKey("HTTPS_PROXY_HOST")) {
            this.getLog().debug((CharSequence)"Setting https.proxyHost from environment variable \"HTTPS_PROXY_HOST\"");
            httpsProxyHost = System.getenv("HTTPS_PROXY_HOST");
        } else if (activeProxy != null) {
            this.getLog().debug((CharSequence)("Setting https.proxyHost from pom.xml / settings.xml proxy \"" + activeProxy.getId() + "\""));
            httpsProxyHost = activeProxy.getHost();
        }
        if (httpsProxyHost != null && !httpsProxyHost.isEmpty() && !"null".equalsIgnoreCase(httpsProxyHost)) {
            this.getLog().debug((CharSequence)("Setting https.proxyHost=" + httpsProxyHost));
            System.setProperty("https.proxyHost", httpsProxyHost);
        } else {
            this.getLog().debug((CharSequence)"https.proxyHost not set!");
            System.clearProperty("https.proxyHost");
        }
        String httpsProxyPort = System.getProperty("https.proxyPort");
        if (httpsProxyPort != null) {
            this.getLog().debug((CharSequence)"Setting https.proxyPort from system property \"https.proxyPort\"");
        } else if (System.getenv().containsKey("HTTPS_PROXY_PORT")) {
            this.getLog().debug((CharSequence)"Setting https.proxyPort from environment variable \"HTTPS_PROXY_PORT\"");
            httpsProxyPort = System.getenv("HTTPS_PROXY_PORT");
        } else if (activeProxy != null) {
            this.getLog().debug((CharSequence)("Setting https.proxyPort from pom.xml / settings.xml proxy \"" + activeProxy.getId() + "\""));
            httpsProxyPort = Integer.toString(activeProxy.getPort());
        }
        if (httpsProxyPort != null && !httpsProxyPort.isEmpty() && !"-1".equalsIgnoreCase(httpsProxyPort)) {
            this.getLog().debug((CharSequence)("Setting https.ProxyPort=" + httpsProxyPort));
            System.setProperty("https.proxyPort", httpsProxyPort);
        } else {
            this.getLog().debug((CharSequence)"https.proxyPort not set!");
            System.clearProperty("https.proxyPort");
        }
        String httpNonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (httpNonProxyHosts != null) {
            this.getLog().debug((CharSequence)"Setting http.nonProxyHosts from system property \"http.nonProxyHosts\"");
        } else if (System.getenv().containsKey("NO_PROXY")) {
            this.getLog().debug((CharSequence)"Setting http.nonProxyHosts from environment variable \"NO_PROXY\"");
            httpNonProxyHosts = System.getenv("NO_PROXY");
        } else if (activeProxy != null) {
            this.getLog().debug((CharSequence)("Setting http.nonProxyHosts from pom.xml / settings.xml proxy \"" + activeProxy.getId() + "\""));
            httpNonProxyHosts = activeProxy.getNonProxyHosts();
        }
        if (httpNonProxyHosts != null && !httpNonProxyHosts.isEmpty() && !"null".equalsIgnoreCase(httpNonProxyHosts)) {
            this.getLog().debug((CharSequence)("Setting http.nonProxyHosts=" + httpNonProxyHosts));
            System.setProperty("http.nonProxyHosts", httpNonProxyHosts);
        } else {
            this.getLog().debug((CharSequence)"http.nonProxyHosts not set!");
            System.clearProperty("http.nonProxyHosts");
        }
    }
}

