/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.soa.plugin;

import oracle.integration.platform.testfwk.ant.ScaTestException;
import oracle.soa.sca.test.SoaTestWrapper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, name="test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresProject=true, threadSafe=true)
public class SoaTest
extends AbstractMojo {
    @Parameter(property="format", defaultValue="native")
    private String format;
    @Parameter(property="result", defaultValue="${java.io.tmpdir}/out")
    private String result;
    @Parameter(property="input", required=true)
    private String input;
    @Parameter(property="timeout", defaultValue="300")
    private int timeout;
    @Parameter(property="partition", defaultValue="default")
    private String partition;
    @Parameter(property="soa.test.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="jndi.properties.input", required=true)
    private String jndiPropertiesInput;

    public void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skip flag = true, skipping sar testing");
            return;
        }
        SoaTestWrapper soa = new SoaTestWrapper(this.getLog());
        soa.setCompositeDN(this.partition + "/" + this.input);
        soa.setTimeout("" + this.timeout);
        soa.setXSL(this.format);
        soa.setRunName("oracle-soa-plugin-scatest");
        soa.setResultsdir(this.result);
        soa.setContext(this.jndiPropertiesInput);
        soa.init();
        try {
            soa.execute();
        }
        catch (ScaTestException e) {
            throw new MojoExecutionException("Failed to complete SOA test execution.", (Exception)((Object)e));
        }
    }

    private boolean isSkip() {
        return this.skip;
    }
}

