<%@ page import="java.io.PrintWriter" %>
<%@ page import="oracle.as.scheduler.webservice.WsUtil" %>
<%--
  User: Vijay Nanjundaswamy
  Date: Sep 05 2013
  Time: 11:15:05 AM
  Description: This JSP page calculates and advertises the wsdl URLs for ESS WebServices, 
               using WsUtil methods to get the URL Prefix.
  Last Updated: Sep 14 2020             
--%>

<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<%!
    public void printEssWebServicesWsdlURLs(JspWriter w) {    

        try {
        
            String prefix = null, sslPortPrefix = null, nonsslPortPrefix = null;           
            
            //first get FrontEnd urls
            try {  prefix = WsUtil.getJRFHostPortPrefix(true, true); }
            catch (Exception ex) { prefix = null; }
            
            if ((!WsUtil.isEmptyString(prefix)) && 
                        (prefix.toLowerCase().startsWith("https:")))
            {
                sslPortPrefix = prefix;
            }
            
            try {  prefix = WsUtil.getJRFHostPortPrefix(false, true); }
            catch (Exception ex) { prefix = null; }  
                      
            if ((!WsUtil.isEmptyString(prefix)) && 
                        (prefix.toLowerCase().startsWith("http:")))
            {
                nonsslPortPrefix = prefix;
            }       
            
            //get local urls, if FrontEnd not available
            if ((sslPortPrefix == null) && (nonsslPortPrefix == null)) {
            
                try {  prefix = WsUtil.getJRFHostPortPrefix(true, false); }
                catch (Exception ex) { prefix = null; }
            
                if ((!WsUtil.isEmptyString(prefix)) && 
                        (prefix.toLowerCase().startsWith("https:")))
                {
                   sslPortPrefix = prefix;
                }
                
                try {  prefix = WsUtil.getJRFHostPortPrefix(false, false); }
                catch (Exception ex) { 
                    prefix = null; 
                    if (sslPortPrefix == null)
                        throw ex;
                }
            
                if ((!WsUtil.isEmptyString(prefix)) && 
                        (prefix.toLowerCase().startsWith("http:")))
                {
                   nonsslPortPrefix = prefix;
                }                
            }                        
              
            w.println("<font face=\"Arial\" size=\"4\">");

            //Column Headers
            w.println("<tr><td><b>WebService</b></td><td><b>WSDL URL</b></td></tr>");              

            //1. ESSWebService wsdl format: http://essHost:essPort/ess/esswebservice?wsdl
            
            String wsId = "EssWebService";
            String relativeUrl = "ess/esswebservice?wsdl";
            
            w.println(getWsdlURLEntry(wsId, relativeUrl, sslPortPrefix, nonsslPortPrefix));                    
            
            //2. ESSAsyncCallback wsdl format: http://essHost:essPort/ess-async/essasynccallback?wsdl
            
            wsId = "EssAsyncCallbackService";
            relativeUrl = "ess-async/essasynccallback?wsdl";   
            
            w.println(getWsdlURLEntry(wsId, relativeUrl, sslPortPrefix, nonsslPortPrefix));                    
                       
            //3. WebServiceJobCallback wsdl format: http://essHost:essPort/ess-wsjob/async/callback?wsdl
            
            wsId = "EssWsJobAsyncCallbackService";
            relativeUrl = "ess-wsjob/async/callback?wsdl";     
            
            w.println(getWsdlURLEntry(wsId, relativeUrl, sslPortPrefix, nonsslPortPrefix));                    
                    
            w.println("</font>");
        } 
        catch (Exception ex) {
          String msg = "Error determining ESSWebServices wsdl URL's, Cause=" + ex.toString();
          try { w.println(msg);} catch (Exception ex2) { ex.printStackTrace(); };
            //ex.printStackTrace();
        }
    }
    
    private String getWsdlURLEntry(String wsId, String relativeUrl,
                                   String sslPortPrefix, String nonsslPortPrefix) 
    {                     
       String sslUrl    = (sslPortPrefix != null) ? 
                                 (sslPortPrefix + relativeUrl) : null;
                                 
       String nonsslUrl = (nonsslPortPrefix != null) ? 
                                 (nonsslPortPrefix + relativeUrl) : null;

       String wsdlURLEntry = "<tr><td>" + wsId + "</td><td>"
              + ((sslUrl != null) ? 
                     "<a href=\"" + sslUrl + "\">" + sslUrl + "</a><br/>" : "")
              + ((nonsslUrl != null) ? 
                     "<a href=\"" + nonsslUrl + "\">" + nonsslUrl + "</a>" : "")                    
              + "</td></tr>";
              
       return wsdlURLEntry;              
    }      
%>

<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <title>ESS WebServices WSDL URLs</title>
    <style>
        html {visibility:hidden;}
    </style>
    <script>
        if (self===top) {
           document.documentElement.style.visibility='visible';
        } else {
           top.location=self.location;
        }
    </script>
</head>

<body bgcolor=#FFFFFF topmargin="0" bottommargin="0" leftmargin="0"
      rightmargin="0" marginheight="0" marginwidth="0">
<FONT face="Arial">
<BR><BR>
     <CENTER>
     <H3><U><font color="#A52A2A">ESS WebServices WSDL URLs</font></U></H3>
     <TABLE border="1" cellspacing="0" cellpadding="4" bgcolor="#F8F8F8" align="center">
            <%
               // to prevent all framing of this content
               response.addHeader( "X-FRAME-OPTIONS", "DENY" );

               printEssWebServicesWsdlURLs(out);
            %>
     </TABLE>
     </CENTER>
</FONT>
</body>
</html>

