//
// $Header: bpm/main/modules/composer/adf/src/main/resources/META-INF/bpm/jsLibs/processEditor/ExpressionEditor.js /st_pcbpel_12.2.1.4.0soabp/1 2020/12/31 08:32:23 pbsingha Exp $
//
// ExpressionEditor.js
//
// Copyright (c) 2020, Oracle and/or its affiliates. 
//
//    NAME
//     ExpressionEditor.js - <one-line expansion of the name>
//
//    DESCRIPTION
//     <short description of component this file declares/defines>
//
//    NOTES
//     <other useful comments, qualifications, etc. >
//
//    MODIFIED  (MM/DD/YY)
//    manpasin   12/15/20 - Created
//
//******************************************************************
//PROTOTYPE: AUTO SUGGEST
//STATUS: 1.0
//authors: Frank Nimphius, Maroun Imad
//Functionality
//====================================
// Implemented in v 1.0
//1 - Suggest window opens JOB_ID field
//2 - Initial query is to database, follow up queries are in memory
//3 - Enter list with down arrow
//4 - Enter key and mouse click to select
//5 - ESC to close
//******************************************************************
// TODO for v 2.0:
// 1 - create declarative component
// 2 - defer popup open to configurable number of characters typed
// 3 - clean-up JavaScript
// 4 - replace model with Array List
// 5 - fix bugs
//******************************************************************
// TODO for v 2.1:
// 1 - Make declarative component to trigger PPR
// 2 - Support validator and converter on declarative component
//******************************************************************
// TODO for v. 2.2 (JDevleoper 11 R1)
// 1 - use af:resource tag for JavaScript

function handleKeyUpOnSuggestField(evt)
{
    // start the popup aligned to the component that launched it
    inputField = evt.getSource();
    var keyCode = evt.getKeyCode();
    var suggestPopup = inputField.findComponent("suggestPopup");

    /*if (compileTimeOut != null) {
        clearTimeout(compileTimeOut);
    }*/
    var expressionEditorDialog = suggestPopup.getParent().getParent();
    if(expressionEditorDialog.nativeCancel == undefined) {
        // Override dialog cancel. Avoids dialog close when pressing 'esc' key.
        expressionEditorCancelTriggered = false;
        expressionEditorDialog.nativeCancel = AdfRichPopup.prototype.cancel;
        expressionEditorDialog.cancel = function() {
            if(!expressionEditorCancelTriggered) {
                this.nativeCancel();
            }
        };
    }

    expressionCaret.save(inputField);

    //don't open when user "tabs" into field
    if (!suggestPopup.isPopupVisible() &&
        //"." o ctrl+shift+space
        (keyCode == 190 || (keyCode == 32 && evt.getKeyModifiers() == 3)))
    {
        var hints = {align:AdfRichPopup.ALIGN_AFTER_START, alignId:evt.getSource().getClientId() + "::content"};
        suggestPopup.show(hints);
        //disable popup hide to avoid popup to flicker on key press
        if(suggestPopup.hidePopup == undefined) {
            expressionPopupHidden = false;
            suggestPopup.hidePopup = AdfRichPopup.prototype.hide;
            suggestPopup.hide = function() {
                this.hidePopup();
                expressionPopupHidden = true;
                setTimeout("expressionPopupHidden = false", 150);
            };

        }

        showExpressionEditorPopupElement('loading');
        setFocusOnInputField();

        // query suggest list on the server
        AdfCustomEvent.queue(suggestPopup, "suggestServerListener",
            // Send single parameter
            {filterString:expressionCaret.obtainInputContent(inputField).value}, true);
    } else {
        //suppress server access for the following keys for better performance
        if (keyCode == AdfKeyStroke.ARROWLEFT_KEY ||
            keyCode == AdfKeyStroke.ARROWRIGHT_KEY ||
            keyCode == AdfKeyStroke.ARROWDOWN_KEY ||
            keyCode == AdfKeyStroke.ARROWUP_KEY ||
            keyCode == AdfKeyStroke.SHIFT_MASK ||
            keyCode == AdfKeyStroke.END_KEY ||
            keyCode == AdfKeyStroke.ALT_KEY ||
            keyCode == AdfKeyStroke.HOME_KEY) {
            return;
        }

        if (keyCode == AdfKeyStroke.ESC_KEY) {
            evt.cancel();
            evt.stopBubbling();
            expressionEditorCancelTriggered = true;
            setTimeout("expressionEditorCancelTriggered = false", 150);
            return;
        }

        //disableOkButton();

        //wait 2 secs of no typing before compiling
        //compileTimeOut = setTimeout(compileInputField, 2000);

        hidePopup(evt);
    }
}

function enableOkButton(validatedExpression)
{
    if (validatedExpression == inputField.getValue()) {
        var okButton = inputField.getParent().findComponent('ok');
        composer.enableButton(okButton);
    }
}

function disableOkButton()
{
    var okButton = inputField.getParent().findComponent('ok');
    composer.disableButton(okButton);
}

var expressionPopupHidden;
var expressionEditorCancelTriggered;
var compileTimeOut = null;
function compileInputField()
{
    compile(expressionCaret.obtainInputContent(inputField).value);
}
function compile(filterString)
{
    AdfCustomEvent.queue(inputField, "compileListener", {filterString:filterString}, true);
}

function setFocusOnInputField()
{
    setTimeout("expressionCaret.restore(inputField);", 200);
}

/* Function called from UseExpBuilderBean */
function setFocusOnJoblist()
{
    if(inputField.findComponent("suggestPopup").isPopupVisible()) {
        inputField.findComponent('joblist').focus();
    }
}

/**
 * Function called from UseExpBuilderBean
 * @param elem the popup element to show
 */
function showExpressionEditorPopupElement(elem) {
    inputField.findComponent("nosuggestions").setVisible(elem == 'nosuggestions');
    inputField.findComponent("joblist").setVisible(elem == 'joblist');
    inputField.findComponent("loading").setVisible(elem == 'loading');
}

function showExpressionEditorPopupElementIfVisible(elem) {
    if(inputField.findComponent("suggestPopup").isPopupVisible()) {
        showExpressionEditorPopupElement(elem);
    }
}


//TAB and ARROW DOWN keys navigate to the suggest popup
//we need to handle this in the key down event as otherwise
//the TAB doesn't work
function handleKeyDownOnSuggestField(evt)
{
    if (evt.getKeyCode() == AdfKeyStroke.ARROWDOWN_KEY) {
        setFocusOnJoblist();
    }
}

//method called when pressing a key or a mouse button on the list
function handleListSelection(evt)
{
    if (evt.getKeyCode() == AdfKeyStroke.ENTER_KEY ||
        evt.getType() == AdfUIInputEvent.CLICK_EVENT_TYPE) {
        var list = evt.getSource();
        evt.cancel();
        evt.stopBubbling();
        var listValue = list.getProperty("value");
        listValue = listValue.substr(listValue.indexOf(".")+1);
        hidePopup(evt);
        var elem = evt.getSource().findComponent("textbox");
        expressionCaret.insertAtCaret(elem, listValue);
        var el = document.getElementById(elem.getClientId() + "::content");
        compile(el.value);
    }
    //cancel dialog
    else if (evt.getKeyCode() == AdfKeyStroke.ESC_KEY) {
        hidePopup(evt);
        evt.cancel();
        evt.stopBubbling();
    } else if (evt.getKeyCode() == AdfKeyStroke.BACKSPACE_KEY) {
        evt.cancel();
        evt.stopBubbling();
    }
}

function handleExpressionDialog(evt)
{
    var suggestPopup = evt.getSource().findComponent("suggestPopup");
    if (evt.getOutcome() == AdfDialogEvent.OUTCOME_CANCEL && expressionPopupHidden) {
        evt.cancel();
        evt.stopBubbling();
    }
}

//function that re-implements the node functionality for the
//popup to then call it
function hidePopup(evt)
{
    var suggestPopup = evt.getSource().findComponent("suggestPopup");
    showExpressionEditorPopupElement('none');
    suggestPopup.hide();
}

function disableInsertIntoExprBtn(evt) {
    var src = evt.getSource();
    while(src.findComponent("insertBtn") == null) {
        src = src.getParent();
    }
    composer.disableButton(src.findComponent("insertBtn"));
}

function insertIntoExprClick(evt)
{
    if (compileTimeOut != null) {
        clearTimeout(compileTimeOut);
    }

    var source = evt.getSource();
    if (!inputField || inputField == undefined) {
        inputField = source.findComponent("textbox");
    }

    var el = document.getElementById(inputField.getClientId() + "::content");
    var ins = source.getProperty("insertTextValue");
    expressionCaret.insertAtCaret(inputField, ins);

    //wait 2 secs of no typing before compiling
    //compileTimeOut = setTimeout(compileInputField, 2000);
}

function saveExpressionCaret(evt) {
    var source = evt.getSource();
    if (!inputField || inputField == undefined) {
        inputField = source.findComponent("textbox");
    }
    expressionCaret.save(inputField);
}

var inputField;

var expressionCaret = {
    start: 0,
    end: 0,
    inputContent: null,
    save: function(inputField) {
        this.obtainInputContent(inputField);
        if (document.selection) {
            var range = document.selection.createRange();
            if (range.parentElement() != this.inputContent) {
                return;
            }
            var elementRange = range.duplicate();
            elementRange.moveToElementText(this.inputContent);
            var enlargedRange = range.duplicate();
            enlargedRange.setEndPoint("StartToStart",elementRange);
            this.end = enlargedRange.text.length;
            this.start = this.end + range.text.length;
        } else {
            this.start = this.inputContent.selectionStart;
            this.end = this.inputContent.selectionEnd;
        }
    },
    insertAtCaret: function(inputField, text) {
        if(text == null) {
            return;
        }
        this.obtainInputContent(inputField);
        this.inputContent.value = this.inputContent.value.substr(0, this.start)
            + text
            + this.inputContent.value.substr(this.end, this.inputContent.value.length);
        this.end = this.start += text.length;

        this.restore(inputField);
        AdfCustomEvent.queue(inputField, "updateTextBox",
            // Send single parameter
            {textBoxContent:expressionCaret.obtainInputContent(inputField).value}, true);
    },
    restore : function(inputField) {
        this.focus(inputField);
        this.obtainInputContent(inputField);
        if (document.selection) {
            var range = document.selection.createRange();
            range.moveToElementText(this.inputContent);
            range.moveStart("character", this.start);
            range.moveEnd("character", this.end - this.inputContent.value.length)
            range.select();
        } else {
            try {
                this.inputContent.setSelectionRange(this.start, this.end);
            } catch(e) {}
        }
    },
    focus: function(inputField) {
        this.obtainInputContent(inputField);
        try {
            this.inputContent.focus();
        } catch (e) {}
    },
    obtainInputContent: function(inputField) {
        this.inputContent = document.getElementById(inputField.getClientId() + "::content");
        return this.inputContent;
    }
};

function compilerIconHandler(evt)
{
    evt.cancel();
    evt.getSource().findComponent('errorTab').setDisclosed(true);
}