#!/bin/sh

CUR_DIR=`dirname $0`

ORACLE_HOME=`cd $CUR_DIR/..; pwd`
MW_HOME=${MW_HOME}


# Following is needed to set JAVA_HOME
# Get WL_HOME


if [ -z "${MW_HOME}" ]; then
 MW_HOME=`cd $ORACLE_HOME/..; pwd` 
fi

asType="UNKNOWN"

if [ -f ${MW_HOME}/oracle_common/common/bin/setHomeDirs.sh ]; then
   asType="WebLogic" 

elif [ -f ${ORACLE_HOME}/../../middleware/oracle_common/common/bin/setHomeDirs.sh ]; then
    asType="WebLogic"   
    MW_HOME=`cd $ORACLE_HOME/../../middleware; pwd` 

fi

export MW_HOME


case "${asType}" in
  "WebLogic" )
    echo "**************************************************************"
    echo "INFO: Detected a WebLogic Installation."
    #echo "**************************************************************"
    . "${MW_HOME}/oracle_common/common/bin/setHomeDirs.sh"

    # Get JAVA_HOME
    . "${MW_HOME}/oracle_common/common/bin/commEnv.sh"
    ;;

  * )
    echo "ERROR: Unknown App Server"
    exit 1
    ;;
esac

LIB=$ORACLE_HOME/soa/modules/oracle.soa.fabric_11.1.1/oracle-soa-client-api.jar

# Display soa-infra version
MANIFEST_MF="unzip -p ${LIB} META-INF/MANIFEST.MF"
#PS4 shipped with 12.2.1.3 in version prodver=`$MANIFEST_MF | grep "Implementation-Version"| cut -d':' -f2 | sed -e "s/-SNAPSHOT//g;"`
#prodver=`$MANIFEST_MF | grep "Implementation-Version"| cut -d':' -f2 | sed -e "s/-SNAPSHOT//g;" | sed -e "s/12.2.1.3/12.2.1.4/g;"`
#prodlbl=`$MANIFEST_MF | grep "Ade-Label"| cut -d':' -f2`
jdkver=`$MANIFEST_MF | grep "Build-Jdk"| cut -d':' -f2`

# Display soa-infra version
LIB=$ORACLE_HOME/soa/modules/oracle.soa.bpel_11.1.1
CP=$LIB/orabpel.jar:$LIB/orabpel-common.jar:$ORACLE_HOME/soa/modules/oracle.soa.fabric_11.1.1/fabric-runtime.jar
$JAVA_HOME/bin/java -cp $CP com.collaxa.cube.util.BuildInfo

cat <<EOF
Compile JDK     :${jdkver}
Java Home       : ${JAVA_HOME}

Runtime JDK Version
EOF

${JAVA_HOME}/bin/java -version

echo "**************************************************************"
