"""
Caution: This file is part of the WLST implementation. Do not edit or move this file because this may cause
WLST commands and scripts to fail. Do not try to reuse the logic in this file or keep copies of this file because
this could cause your WLST scripts to fail when you upgrade to a different version of WLST.

 Copyright (c) 2009, 2020, Oracle and/or its affiliates. 

--------------------------------------------
miclin 04/20/11 - creation
--------------------------------------------
"""

from oracle.integration.platform.blocks.deploy.client import CompositeMDSTools
from oracle.integration.platform import WLSTMessageBundle
from oracle.integration.platform import WLSTMessageID

"""
-------------------------------------------------------------------------------
Remove composite operations
-------------------------------------------------------------------------------
"""
# This command removes composite from deployed-composites.xml and its artifacts from MDS repository.
# SOA needs to be in shutdown mode. The composite and its data will be removed from MDS repository
# permanently. This command need to be used with caution - should only be used if SOA server cannot
# be started due to composite corruption. In most cases, the removed composite needs to be redeployed
# after the SOA server restart.
#
# @jdbcURL The JDBC URL for connecting to the SOA MDS repository
# @user/password The user name and password for connecting to the SOA MDS repository
# @compositeName The name of the composite to be removed
# @revision The revision ID of the composite to be removed
# @folder The folder that the composite is located, optional, default value is 'default'
# @removeData Whether to remove the associated artifacts from MDS, optional, default is False.
def sca_removeComposite(jdbcURL, user, password, compositeName, revision, folder=None, partition='default', removeData=False):
   #partition is deprecated, kept for backward compatibility
   if folder is None:
     folder = partition
     
   print 'jdbcURL =', jdbcURL
   print 'user =', user
#   print 'password =', password
   print 'compositeName =', compositeName
   print 'revisionID =', revision
   compositeDN = folder + '/' + compositeName + '!' + revision
   print 'compositeDN =', compositeDN
#   print 'WARNING: the SOA server needs to be in shutdown mode before executing this command.'
#   print '         It will remove the composite from SOA platform.'
#   print '         It should only be used when SOA server cannot be started.'
   if removeData:
     print WLSTMessageBundle.getStringNoArg(WLSTMessageID.MSG_RMCOMPOSITE_DATA_WARNING)
   else:
     print WLSTMessageBundle.getStringNoArg(WLSTMessageID.MSG_RMCOMPOSITE_WARNING)
   cont = raw_input('Do you want to continue? [no]')
   if cont=='y' or cont=='Y' or cont=='yes' or cont=='YES':
     client = CompositeMDSTools(jdbcURL, user, password)
     try:
       client.removeComposite(compositeDN, removeData)
       client.cleanup()
#       print '---->Removing composite (', compositeDN, ') success.'
       if removeData:
         print WLSTMessageBundle.getStringWithOneArg(WLSTMessageID.MSG_RMCOMPOSITE_DATA_SUCCESS, compositeDN)
       else:
         print WLSTMessageBundle.getStringWithOneArg(WLSTMessageID.MSG_RMCOMPOSITE_SUCCESS, compositeDN)
     except Exception, detail:
#      print 'Exception:', detail
       print WLSTMessageBundle.getStringWithOneArg(WLSTMessageID.MSG_EXCEPTION, detail)


"""
-------------------------------------------------------------------------------
Undeploy retired composites operations
-------------------------------------------------------------------------------
"""
# This command undeploy retired composites from deployed-composites.xml and remove
# corresponding composite artifacts from MDS repository.
# SOA needs to be in shutdown mode. The retired composite and its data will be removed from MDS repository
# permanently.
# This command need to be used with caution.
#
# @jdbcURL The JDBC URL for connecting to the SOA MDS repository
# @user/password The user name and password for connecting to the SOA MDS repository
# @soaJdbcURL The JDBC URL for connecting to the SOA-INFRA repository
# @soaUser/soaPassword The user name and password for connecting to the SOA-INFRA repository
# @folder The folder that the composites are located, optional, default value is 'default'
# @preview If set to True, it will prompts the info about the composites to be undeployed, default value is 'False'
def sca_undeployRetiredComposites_offline(jdbcURL, user, password, soaJdbcURL, soaUser, soaPassword, folder=None, partition='default', preview=False):
   #partition is deprecated, kept for backward compatibility
   if folder is None:
     folder = partition
     
   print 'jdbcURL =', jdbcURL
   print 'user =', user
#   print 'password =', password
   print 'soaJdbcURL =', soaJdbcURL
   print 'soaUser =', soaUser
#   print 'soaPassword =', soaPassword
   print 'folder =', folder
   print 'preview =', preview
   client = CompositeMDSTools(jdbcURL, user, password)
   try:
       client.undeployRetiredComposites(soaJdbcURL, soaUser, soaPassword, folder, preview)
       client.cleanup()
       if preview:
         print '---->Undeploy retired composites in preview mode success.'
       else:
         print '---->Undeploy retired composites success.'
   except Exception, detail:
#      print 'Exception:', detail
       print WLSTMessageBundle.getStringWithOneArg(WLSTMessageID.MSG_EXCEPTION, detail)

# This command undeploys all retired inactive composites from deployed-composites.xml and remove
# corresponding composite artifacts from MDS repository.
# If the retired composite has been running longer than "maxDaysRunning" then it is considered not running
# and will be removed. If maxDaysRunning = -1 (the default) then no running composites will be removed. 
# SOA needs to be in shutdown mode. The retired composite and its data will be removed from MDS repository
# permanently.
# This command is intended to be used as part of the RUPGrade process but can be used to clean up retired
# composites anytime the server is shutdown.
#
# This command should be used with caution.
#
# @jdbcURL The JDBC URL for connecting to the SOA MDS repository
# @user/password The user name and password for connecting to the SOA MDS repository
# @soaJdbcURL The JDBC URL for connecting to the SOA-INFRA repository
# @soaUser/soaPassword The user name and password for connecting to the SOA-INFRA repository
# @folder The folder that the composites are located, optional, default value is 'default'
# @maxDaysRunning If the number of days the retired composites has been running is more than this value then the
# composite is considered not running and will be removed.
#   A value of -1 means any running composite will not be removed. 
#   A value of 0 means all running composites will be removed
#   optional, default value is -1 (no running composites will be removed)
# @preview If set to True, it will only display the composites to be undeployed, optional, default value is 'False'
def sca_undeployRetiredCompositesOffline(jdbcURL, user, password, soaJdbcURL, soaUser, soaPassword, folder=None, partition='default', maxDaysRunning=-1, preview=False):
   #partition is deprecated, kept for backward compatibility
   if folder is None:
     folder = partition
     
   print 'jdbcURL = ', jdbcURL
   print 'user = ', user
   print 'password = *****'
   print 'soaJdbcURL = ', soaJdbcURL
   print 'soaUser = ', soaUser
   print 'soaPassword = *****'
   print 'folder = ', folder
   print 'maxDaysRunning = ', maxDaysRunning
   print 'preview =', preview
   client = CompositeMDSTools(jdbcURL, user, password)
   try:
       client.undeployRetiredCompositesOffline(soaJdbcURL, soaUser, soaPassword, folder, maxDaysRunning, preview, None)
       client.cleanup()
       if preview:
         print '---->Undeploy all retired composites in preview mode success.'
       else:
         print '---->Undeploy all retired composites success.'
   except Exception, detail:
#      print 'Exception:', detail
       print WLSTMessageBundle.getStringWithOneArg(WLSTMessageID.MSG_EXCEPTION, detail)

"""
-------------------------------------------------------------------------------
import metadata offline

example1 : sca_transferDataToMDS('jdbc:oracle:thin:@localhost:17969:db204', 'REL13TEST_MDS', 'welcome1', fromLocation, docs='/soa/configuration/default/soa-infra-config.xml')
example2 : sca_transferDataToMDS('jdbc:oracle:thin:@localhost:17969:db204', 'MAIN_MDS', 'welcome1', '/tmp/test3/', docs='/soa/configuration/default/mdssys/cust/Global/GLOBAL/soa-infra-config.xml.xml')

-------------------------------------------------------------------------------
"""
# This command transfers artifacts to MDS repository offline.
# SOA may need to be restarted to reload the updated document.
#
# @jdbcURL The JDBC URL for connecting to the SOA MDS repository
# @user/password The user name and password for connecting to the SOA MDS repository
# @fromLocation The location of the source documents
# @docs document pattern to transfer.
def sca_transferDataToMDS(jdbcURL, user, password, fromLocation, docs=None):
   #partition is deprecated, kept for backward compatibility
   print 'jdbcURL =', jdbcURL
   print 'user =', user
#   print 'password =', password
   print 'fromLocation =', fromLocation
   print 'docs =', docs

   cont = raw_input('transferDataToMDS , Do you want to continue, Enter yes and <Enter> to Continue? [no]')
   if cont=='y' or cont=='Y' or cont=='yes' or cont=='YES':
     client = CompositeMDSTools(jdbcURL, user, password)
     try:
       client.transferDataToMDS(fromLocation, docs, None)
       client.cleanup()
       print '---->sca_transferDataToMDS success.'
     except Exception, detail:
      print 'Exception in sca_transferDataToMDS :', detail

"""
-------------------------------------------------------------------------------
This command exports artifacts from MDS  offline.

example1 :sca_exportDataFromMDS('jdbc:oracle:thin:@localhost:17969:db204', 'MAIN_MDS', 'welcome1', '/tmp/test3/', docs='/soa/configuration/default/soa-infra-config.xml')
example2 :sca_exportDataFromMDS('jdbc:oracle:thin:@localhost:17969:db204', 'MAIN_MDS', 'welcome1', '/tmp/test3/', docs='/soa/configuration/default/mdssys/cust/Global/GLOBAL/soa-infra-config.xml.xml')

-------------------------------------------------------------------------------
"""
# @jdbcURL The JDBC URL for connecting to the SOA MDS repository
# @user/password The user name and password for connecting to the SOA MDS repository
# @toLocation The target location the files to be exported to
# @docs document pattern to transfer.
def sca_exportDataFromMDS(jdbcURL, user, password, toLocation, docs):
   #partition is deprecated, kept for backward compatibility
   print 'jdbcURL =', jdbcURL
   print 'user =', user
#   print 'password =', password
   print 'target toLocation =', toLocation
   print 'docs =', docs

   cont = 'Y'
   #raw_input('transferDataToMDS , Do you want to continue? [no]')
   if cont=='y' or cont=='Y' or cont=='yes' or cont=='YES':
     client = CompositeMDSTools(jdbcURL, user, password)
     try:
       client.transferDataFromMDS(toLocation, docs, None)
       client.cleanup()
       print '---->sca_exportDataFromMDS success.'
     except Exception, detail:
      print 'Exception in sca_exportDataFromMDS :', detail

