/**
 *  This file contains code related to loading, syncing and sending the message to client from server and vice-versa
 */


/**
 *  Creates component name class with AdfProcessEditor
 *  and register it wih the ADF component class ProcessEditor
 */

AdfUIComponents.createComponentClass("AdfHumanTaskEditor",
    {
        componentType: "oracle.bpm.composer.HumanTaskEditor",
        propertyKeys: [],
        namingContainer: true,
        superclass: AdfUIComponent
    });

/**
 * Sends a message to the JS Editor.  Invoked by the server via the addition of script
 * to the response.
 * @param msg
 */
AdfHumanTaskEditor.prototype.processMsg = function (msg) {
    this.getPeer().sendHumanTaskMessage(msg);
};

/**
 * Sends message to server for processing of commands and events
 * @param msg
 */
AdfHumanTaskEditor.prototype.sendMessage = function (msg) {
    let processEditor = AdfPage.PAGE.findComponent(this.getClientId());
    let event = new GraphEditorTransportMessageEvent(processEditor, msg);
    event.setPartial(true);
    AdfPage.PAGE.queueEventToServer(event);
};

/**
 * Open editor tab closed validation tab
 */
AdfHumanTaskEditor.prototype.openPropertyEditorTab = function ()
{
    var errorSplitter = AdfPage.PAGE.findComponent('pt1:errorSplitter');
    if (errorSplitter && errorSplitter.getCollapsed())
    {
        errorSplitter.setCollapsed(false);
    }
}
/**
 * Programmatically hide the Process Editor component
 */
AdfHumanTaskEditor.prototype.hide = function () {
    let composerElem = AdfAgent.AGENT.getElementById(this.getClientId());
    composerElem.style.display = 'none';
};

/**
 * Programmatically show the Process Editor component
 */
AdfHumanTaskEditor.prototype.show = function () {
    let composerElem = AdfAgent.AGENT.getElementById(this.getClientId());
    composerElem.style.display = 'block';
};

/**
 *  Create AdfHumanTaskEditorPeer class
 *  This class will manage the dom for the component
 */

AdfRichUIPeer.createPeerClass(AdfRichUIPeer, "AdfHumanTaskEditorPeer", false);

/**
 * Register the class with ADF page
 */
AdfPage.PAGE.getLookAndFeel().registerPeerConstructor(
    "oracle.bpm.composer.HumanTaskEditor",
    "AdfHumanTaskEditorPeer");

/**
 * Initiate class the constructor class
 * @constructor
 */
AdfHumanTaskEditorPeer.InitSubclass = function () {
    AdfObject.ensureClassInitialization(AdfHumanTaskEditorPeer);
}

/**
 * Initialize the associated domElement when the peer is created.  Stateless peers
 * are not bound at the time that this method is called.
 * @param {AdfUIComponent} component Component that this peer will be associated with
 * @param {Object} domElement Root DOM element of this peer
 */
AdfHumanTaskEditorPeer.prototype.InitDomElement = function (component, domElement) {
    AdfHumanTaskEditorPeer.superclass.InitDomElement.call(this, component, domElement);
    this._clientId = component.getClientId();
    this._fetchStatusDiv = AdfAgent.AGENT.getElementById(this.getStatusElementId());
}

/**
 * Notifies the peer that some DOM corresponding to a child (or descendent) has been replaced.
 */
AdfHumanTaskEditorPeer.prototype.DomReplaceNotify = function (domNode) {
    if (!this.isJSEditorLoaded()) {
        this.addProcessEditorToDom(this.getComponent());
    }
    this.hideStatus();
}

AdfHumanTaskEditorPeer.prototype.isJSEditorLoaded = function () {
    return !!document.getElementById("processContainer");
}

AdfHumanTaskEditorPeer.prototype.ResizeNotify = function (
    oldWidth, oldHeight, newWidth, newHeight) {
    AdfHumanTaskEditorPeer.superclass.ResizeNotify.call(
        oldWidth, oldHeight, newWidth, newHeight);

    if (!this.isJSEditorLoaded()) {
        this.addProcessEditorToDom(this.getComponent());
    }
}

AdfHumanTaskEditorPeer.prototype.addProcessEditorToDom = function (component) {
    console.log("AddProcessEditorToDom Called - Handle it")
}

AdfHumanTaskEditorPeer.prototype.displayStatus = function (text) {
    let message = this._fetchStatusDiv;
    message.innerHTML = text;
    let style = message.style;
    if (!style.display || style.display === 'none') {
        style.zIndex = 5;
        style.visibility = 'hidden';
        style.display = 'block';
        // display in the center.
        style.top = Math.floor((this._clientHeight - message.offsetHeight) / 2) + 'px';
        style.left = Math.floor((this._clientWidth - message.offsetWidth) / 2) + 'px';
        style.visibility = 'visible';
    }
}

AdfHumanTaskEditorPeer.prototype.hideStatus = function () {
    this._fetchStatusDiv.style.display = 'none';
}

AdfHumanTaskEditorPeer.processMessageQueue = function (clientId) {
    return AdfPage.PAGE.findComponent(clientId).getPeer().processMessageQueue();
};

AdfHumanTaskEditorPeer.prototype.processMessageQueue = function () {
    if (this.messageQueue && this.messageQueue.length > 0) {
        return this.messageQueue.shift();
    } else {
        this.loaded = true;
        this.messageQueue = undefined;
        return null;
    }
};

AdfHumanTaskEditorPeer.prototype.sendHumanTaskMessage = function (msgXml) {
    window.LoadRoutingSlip(msgXml, 'pt1:tabs:humanTaskEditorTabInc:routing_f:htEditor');
};

AdfHumanTaskEditorPeer.registerCtrlKeyEventListener = function (movieId) {
    return false;
};

AdfHumanTaskEditorPeer.prototype.getStatusElementId = function (clientId) {
    return AdfRichUIPeer.CreateSubId(this._clientId, this.getStatusDivId());
};

AdfHumanTaskEditorPeer.prototype.getStatusDivId = function () {
    return "status";
}

AdfHumanTaskEditorPeer.prototype.createNodeActionEvent = function (tv, params, paramValues) {
    return new AdfProcessComposerNodeActionEvent(tv,
        this.getParamValue("actionEventType", params, paramValues),
        this.getParamValue("clientRowKey", params, paramValues),
        this.getParamValue(
            AdfProcessComposerNodeActionEvent.NODE_ACTION_EVENT_ACTION_COMPONENT_ID,
            params, paramValues)
    );
};

AdfHumanTaskEditorPeer.prototype.getParamValue = function (searchParam, params, paramValues) {
    if (!this.isValidVariable(searchParam))
        return null;

    let index = params.indexOf(searchParam);

    if (index === -1 || index >= paramValues.length)
        return null;

    return paramValues[index];
};

AdfHumanTaskEditorPeer.prototype.isValidVariable = function (testVar)
{
    return !!testVar;
}

function dvt_hv_fpInitNotify(clientId) {
    return _getDataXml(clientId);
}

function dvt_hv_queueEvent(clientId, eventType, params, paramValues) {
    let tv = AdfPage.PAGE.findComponent(clientId);
    let tvPeer = tv.getPeer();
    let evalEventType = eval(eventType);

    let event = null;
    if (evalEventType === AdfHumanTaskComposerFetchEvent.NODE_FETCH_EVENT) {
        event = tvPeer.createFetchEvent(tv, params, paramValues);
    } else if (evalEventType === AdfHumanTaskComposerNodeActionEvent.NODE_ACTION_EVENT) {
        event = tvPeer.createNodeActionEvent(tv, params, paramValues);
    } else if (evalEventType === AdfHumanTaskComposerShowPopupBehaviorEvent.NODE_SHOW_POPUP_BEHAVIOR_EVENT) {
        event = tvPeer.createShowPopupBehaviorEvent(tv, params, paramValues);
    } else if (evalEventType === AdfHumanTaskComposerSelectionEvent.SELECTION_EVENT) {
        event = tvPeer.createSelectionEvent(tv, params, paramValues);
    }
    if (null === event || undefined === event)
        return;

    event.setPartial(true);
    AdfPage.PAGE.queueEventToServer(event);
}

//End Peer class