/**
 *  This file contains code related to loading, syncing and sending the message to client from server and vice-versa
 */


/**
 *  Creates component name class with AdfProcessEditor
 *  and register it wih the ADF component class ProcessEditor
 */

AdfUIComponents.createComponentClass("AdfProcessEditor",
    {
        componentType: "oracle.bpm.composer.ProcessEditor",
        propertyKeys: [],
        namingContainer: true,
        superclass: AdfUIComponent
    });

/**
 * Sends a message to the JS Editor.  Invoked by the server via the addition of script
 * to the response.
 * @param msg
 */
AdfProcessEditor.prototype.processMsg = function (msg) {
    //this.getPeer() returns the status node inside  parent processEditor node
    this.getPeer().sendEditorProcessMessage(msg);
};

/**
 * This gets called from response received from server to sync any model changes in editor
 * @param postSyncActionType
 */
AdfProcessEditor.prototype.syncModel = function (postSyncActionType) {
    let customEvent = new CustomEvent("syncModel", {detail: postSyncActionType}); //will not work in <= ie9
    AdfAgent.AGENT.getElementById(this.getClientId()).dispatchEvent(customEvent);
};

/**
 * Sends message to server for processing of commands and events
 * @param msg
 */
AdfProcessEditor.prototype.sendMessage = function (msg) {
    let processEditor = AdfPage.PAGE.findComponent(this.getClientId());
    let event = new GraphEditorTransportMessageEvent(processEditor, msg);
    event.setPartial(true);
    AdfPage.PAGE.queueEventToServer(event);
};

/**
 * Open editor tab closed validation tab
 */
AdfProcessEditor.prototype.openPropertyEditorTab = function ()
{
    var errorSplitter = AdfPage.PAGE.findComponent('pt1:errorSplitter');
    if (errorSplitter && errorSplitter.getCollapsed())
    {
        errorSplitter.setCollapsed(false);
    }
}
/**
 * Programmatically hide the Process Editor component
 */
AdfProcessEditor.prototype.hide = function () {
    let composerElem = AdfAgent.AGENT.getElementById(this.getClientId());
    composerElem.style.display = 'none';
};

/**
 * Programmatically show the Process Editor component
 */
AdfProcessEditor.prototype.show = function () {
    let composerElem = AdfAgent.AGENT.getElementById(this.getClientId());
    composerElem.style.display = 'block';
};

/**
 *  Create AdfProcessEditorPeer class
 *  This class will manage the dom for the component
 */

AdfRichUIPeer.createPeerClass(AdfRichUIPeer, "AdfProcessEditorPeer", false);

/**
 * Register the class with ADF page
 */
AdfPage.PAGE.getLookAndFeel().registerPeerConstructor(
    "oracle.bpm.composer.ProcessEditor",
    "AdfProcessEditorPeer");

/**
 * Initiate class the constructor class
 * @constructor
 */
AdfProcessEditorPeer.InitSubclass = function () {
    AdfObject.ensureClassInitialization(AdfProcessEditorPeer);
}

/**
 * Initialize the associated domElement when the peer is created.  Stateless peers
 * are not bound at the time that this method is called.
 * @param {AdfUIComponent} component Component that this peer will be associated with
 * @param {Object} domElement Root DOM element of this peer
 */
AdfProcessEditorPeer.prototype.InitDomElement = function (component, domElement) {
    AdfProcessEditorPeer.superclass.InitDomElement.call(this, component, domElement);
    this._clientId = component.getClientId();
    this._fetchStatusDiv = AdfAgent.AGENT.getElementById(this.getStatusElementId());
}

/**
 * Notifies the peer that some DOM corresponding to a child (or descendent) has been replaced.
 */
AdfProcessEditorPeer.prototype.DomReplaceNotify = function (domNode) {
    if (!this.isJSEditorLoaded()) {
        this.addProcessEditorToDom(this.getComponent());
    }
    this.hideStatus();
}

AdfProcessEditorPeer.prototype.isJSEditorLoaded = function () {
    return !!document.getElementById("processContainer");
}

AdfProcessEditorPeer.prototype.ResizeNotify = function (
    oldWidth, oldHeight, newWidth, newHeight) {
    AdfProcessEditorPeer.superclass.ResizeNotify.call(
        oldWidth, oldHeight, newWidth, newHeight);

    if (!this.isJSEditorLoaded()) {
        this.addProcessEditorToDom(this.getComponent());
    }
}

AdfProcessEditorPeer.prototype.addProcessEditorToDom = function (component) {
    console.log("AddProcessEditorToDom Called - Handle it")
}

AdfProcessEditorPeer.prototype.displayStatus = function (text) {
    let message = this._fetchStatusDiv;
    message.innerHTML = text;
    let style = message.style;
    if (!style.display || style.display === 'none') {
        style.zIndex = 5;
        style.visibility = 'hidden';
        style.display = 'block';
        // display in the center.
        style.top = Math.floor((this._clientHeight - message.offsetHeight) / 2) + 'px';
        style.left = Math.floor((this._clientWidth - message.offsetWidth) / 2) + 'px';
        style.visibility = 'visible';
    }
}

AdfProcessEditorPeer.prototype.hideStatus = function () {
    this._fetchStatusDiv.style.display = 'none';
}

AdfProcessEditorPeer.processMessageQueue = function (clientId) {
    return AdfPage.PAGE.findComponent(clientId).getPeer().processMessageQueue();
};

AdfProcessEditorPeer.prototype.processMessageQueue = function () {
    if (this.messageQueue && this.messageQueue.length > 0) {
        return this.messageQueue.shift();
    } else {
        this.loaded = true;
        this.messageQueue = undefined;
        return null;
    }
};

AdfProcessEditorPeer.prototype.sendEditorProcessMessage = function (msgXml) {
    if (this.loaded) {
        let customEvent = new CustomEvent("processMessage", {detail: msgXml}); //will not workin in <= ie9
        AdfAgent.AGENT.getElementById(this._clientId).dispatchEvent(customEvent);
        return true;
    } else {
        if (!this.messageQueue) {
            this.messageQueue = [];
        }
        this.messageQueue.push(msgXml);
        return false;
    }
};

AdfProcessEditorPeer.registerCtrlKeyEventListener = function (movieId) {
    return false;
};

AdfProcessEditorPeer.prototype.getStatusElementId = function (clientId) {
    return AdfRichUIPeer.CreateSubId(this._clientId, this.getStatusDivId());
};

AdfProcessEditorPeer.prototype.getStatusDivId = function () {
    return "status";
}

AdfProcessEditorPeer.prototype.createNodeActionEvent = function (tv, params, paramValues) {
    return new AdfProcessComposerNodeActionEvent(tv,
        this.getParamValue("actionEventType", params, paramValues),
        this.getParamValue("clientRowKey", params, paramValues),
        this.getParamValue(
            AdfProcessComposerNodeActionEvent.NODE_ACTION_EVENT_ACTION_COMPONENT_ID,
            params, paramValues)
    );
};

AdfProcessEditorPeer.prototype.getParamValue = function (searchParam, params, paramValues) {
    if (!this.isValidVariable(searchParam))
        return null;

    let index = params.indexOf(searchParam);

    if (index === -1 || index >= paramValues.length)
        return null;

    return paramValues[index];
};

AdfProcessEditorPeer.prototype.isValidVariable = function (testVar)
{
    return !!testVar;
}

function dvt_hv_fpInitNotify(clientId) {
    return _getDataXml(clientId);
}

function dvt_hv_queueEvent(clientId, eventType, params, paramValues) {
    let tv = AdfPage.PAGE.findComponent(clientId);
    let tvPeer = tv.getPeer();
    let evalEventType = eval(eventType);

    let event = null;
    if (evalEventType === AdfProcessComposerFetchEvent.NODE_FETCH_EVENT) {
        event = tvPeer.createFetchEvent(tv, params, paramValues);
    } else if (evalEventType === AdfProcessComposerNodeActionEvent.NODE_ACTION_EVENT) {
        event = tvPeer.createNodeActionEvent(tv, params, paramValues);
    } else if (evalEventType === AdfProcessComposerShowPopupBehaviorEvent.NODE_SHOW_POPUP_BEHAVIOR_EVENT) {
        event = tvPeer.createShowPopupBehaviorEvent(tv, params, paramValues);
    } else if (evalEventType === AdfProcessComposerSelectionEvent.SELECTION_EVENT) {
        event = tvPeer.createSelectionEvent(tv, params, paramValues);
    }
    if (null === event || undefined === event)
        return;

    event.setPartial(true);
    AdfPage.PAGE.queueEventToServer(event);
}

//End Peer class
