#!/bin/sh

CUR_DIR=`dirname $0`

ORACLE_HOME=$CUR_DIR/..

# Following is needed to set JAVA_HOME
# Get WL_HOME 
MW_HOME=${ORACLE_HOME}/..
COMMON_COMPONENTS_HOME="${ORACLE_HOME}/../oracle_common"

asType="UNKNOWN"

if [ -f ${MW_HOME}/oracle_common/common/bin/setHomeDirs.sh ]; then
   asType="WebLogic"
fi

case "${asType}" in
  "WebLogic" )
    echo "**************************************************************"
    echo "INFO: Detected a WebLogic Installation."
    echo "**************************************************************"
    . "${MW_HOME}/oracle_common/common/bin/setHomeDirs.sh"

    # Get JAVA_HOME
    . "${MW_HOME}/oracle_common/common/bin/commEnv.sh"
    ;;

  * )
    echo "ERROR: Unknown App Server"
    exit 1
    ;;
esac

LIB=$MW_HOME/mft/modules/oracle.mft/core.jar

# Display MFT version
CP=$LIB
$JAVA_HOME/bin/java -cp $CP oracle.tip.mft.shared.common.BuildInfo


# Display versions of dependencies in JRF
#MANIFEST_MF="unzip -p $COMMON_COMPONENTS_HOME/modules/internal/features/jrf_wlsFmw_oracle.jrf.wls.classpath_12.1.3.jar META-INF/MANIFEST.MF"
#firstLine=`$MANIFEST_MF | grep -n "Implementation-Version"| cut -d':' -f1`
#lastLine=`$MANIFEST_MF | grep -n "Class-Path"| cut -d':' -f1`
#headLine=`expr $lastLine - 1`
#tailLine=`expr $lastLine - $firstLine`
#buildNo=`$MANIFEST_MF | head -$headLine | tail -$tailLine`
#echo ""
#echo "Oracle ${buildNo}" | sed 's/
#//g'
MANIFEST_MF="unzip -p ${LIB} META-INF/MANIFEST.MF"
prodver=`$MANIFEST_MF | grep "Implementation-Version"| cut -d':' -f2 | sed -e "s/-SNAPSHOT//g;"`
prodlbl=`$MANIFEST_MF | grep "Ade-Label"| cut -d':' -f2`
jdkver=`$MANIFEST_MF | grep "Build-Jdk"| cut -d':' -f2`

cat <<EOF
Compile JDK     :${jdkver}
Java Home       : ${JAVA_HOME}

Runtime JDK Version
EOF

${JAVA_HOME}/bin/java -version

echo "**************************************************************"
