Rem
Rem $Header: ess/sql/oracle/createschema_ess_oracle.sql /st_pcbpel_12.2.1.4.0soabp/1 2023/08/26 00:08:10 apfwkr Exp $
Rem
Rem createschema_ess_oracle.sql
Rem
Rem Copyright (c) 2006, 2023, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem  NAME
Rem    createschema_ess_oracle.sql - Create ESS schema objects
Rem
Rem  DESCRIPTION
Rem    Main script for any RCU DataLoad actions for Oracle database.
Rem    It creates schema objects owned by ESS schema user.
Rem    Assumes the SystemLoad step has already been done.
Rem
Rem    This script used by ESS RCU for FMW consolidated schema and
Rem    ESS standalone schema.
Rem
Rem  USAGE
Rem    createschema_ess_oracle  <schema_user> <default_tablespace>
Rem
Rem    This script should be run as component schema user.
Rem
Rem  NOTES
Rem    Per 12c RCU guidelines, scripts executed during DataLoad should
Rem    be run as the schema user. Also, DataLoad scripts should not use
Rem    ALTER SESSION SET CURRENT_SCHEMA, although unclear if that is more
Rem    of guideline or hard rule.
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  apfwkr      08/23/23 - CI# 35738532 of
Rem  apfwkr      08/23/23 - apfwkr_ci_backport_34756825_12.2.1.6.0soabp from
Rem  apfwkr      08/23/23 - st_pcbpel_12.2.1.6.0soabp.
Rem  apfwkr      08/23/23 - CI# 35738532
Rem                         apfwkr_ci_backport_34756825_12.2.1.4.0soabp
Rem  apfwkr      08/17/23 - CI# 35719542 of psadavar_bug-34756825_1221 .
Rem  apfwkr      08/17/23 - CI# 35719542
Rem  apfwkr      08/17/23 - apfwkr_ci_backport_34756825_12.2.1.6.0soabp from
Rem                         main
Rem  psadavar    11/22/22 - BugFix#34756825 - Disable parallel dml execution.
Rem  kbittler    09/10/18 - add back (empty) aq package/proc
Rem  chall       09/28/16 - FMW consolidated schema support; create tables in
Rem                         designated tablespace
Rem  chall       07/13/16 - disable aq notification support
Rem  chall       09/22/15 - location of umbrella plsql load scripts
Rem  chall       02/19/15 - Scheduler/AQ setup as ESS schema user; admin user
Rem                         does Scheduler job class grant for Database Vault
Rem  chall       06/26/12 - 12c twophase rcu changes
Rem  chall       09/28/11 - sql structure reorg
Rem  aweisber    09/01/11 - Elevating Object Creation
Rem  chall       12/13/09 - add AQ/Scheduler notify setup script
Rem  chall       04/08/09 - ess_version package now in essversion.sql
Rem  chall       03/23/09 - use begin/end rather than execute for rcu tool
Rem  chall       03/19/09 - schema version support
Rem  chall       08/14/07 - bugfix 6000335; multiple schema support
Rem  chall       04/10/07 - call ess_plsql_job.sql script
Rem  axdsilva    10/26/06 - Created
Rem
Rem =======================================================================

Rem &&1 - schema user
Rem &&2 - tablespace

-- Define user variable for a TABLESPACE clause to specify a designated
-- tablespace for sql statements that create tables and indexes.
-- Some scripts used by this script assume this variable has been set.
define uvTablespace = " tablespace &&2 "

begin
  dbms_output.put_line('Schema user: &&1, Tablespace: &&2, ' ||
                       'uvTablespace: [&&uvTablespace]');
end;
/


-- The RCU tool does not support and ignores the WHENEVER statements.
-- It has value only if this script called externally (e.g., via SQLPlus)
-- which is not recommended.
--
-- ESS RCU runs this script when connected as the component schema user.
-- The ALTER SESSION it would essentially be a no-op.

whenever sqlerror exit

alter session disable parallel dml;
--%alter session set current_schema=&&1;

-- Sanity that current_schema is ESS schema owner.
declare
  v_actual varchar2(30) := sys_context('userenv', 'current_schema');
  v_expected varchar2(30) := upper('&&1');
begin
  if v_actual != v_expected then
    raise_application_error(-20000,
        'CURRENT_SCHEMA is '||v_actual||' but expected '||v_expected);
  end if;
end;
/

whenever sqlerror continue

-- load migration support before we start using it
@@ess_mig_table.sql
@@plsql/psessi_migrate.sql
@@plsql/pbessi_migrate.sql
@@plsql/essi_validate_proc.sql

-- indicate ESS schema being loaded
begin
  essi_migrate.loading(validate_proc => 'essi_validate_proc');
end;
/

@@essversion.sql
@@ess_table.sql

@@load_pkg_spec.sql

-- ess_data_security is referenced by other ESS plsql packages.
-- This synonym is replaced by CP/fusion scripts if this ESS schema is
-- linked to a fusion schema.
create or replace synonym ess_data_security for ess_data_security_standalone;

@@load_proc.sql
@@view/ess_view.sql
@@load_pkg_body.sql

@@purge_ess_oracle.sql

-- Object load and setup needed for Oracle Scheduler job support used by
-- ESS SQL job support.
-- Note: The "GRANT EXECUTE to PUBLIC" for grant Oracle Scheduler job class
-- must be done as RCU admin user to succeed for Database Vault enabled db.
-- The grant will be attempted during PostDataLoad.
@@load_schjob.sql
@@sqljob/ess_plsql_runtime.sql

-- Note: Phasing out use of AQ notification support.
-- Object load and setup needed for AQ notification support for ESS SQL jobs.
-- Tasks needed for AQ notification callback should be done as ESS schema
-- user so the AQ notify registration is associated with ESS schema user.
@@load_schjob_aqnotify.sql
--%@@sqljob/ess_scheduler_notify.sql

commit;

-- Indicate ESS schema loaded and perform validation.
begin
  essi_migrate.loaded(schema_version => essi_version.ess_schema_version);
end;
/

begin
  essi_migrate.validate();
end;
/

rem ===== End: createschema_ess_oracle.sql ==============================

exit
