Rem
Rem $Header: ess/sql/oracle/ess_priv_grants.sql /st_pcbpel_12.2.1.4.0soabp/2 2023/02/22 14:35:51 apfwkr Exp $
Rem
Rem ess_priv_grants.sql
Rem
Rem Copyright (c) 2016, 2023, Oracle and/or its affiliates. 
Rem
Rem  NAME
Rem    ess_priv_grants.sql - Grant privileges needed by ESS component
Rem
Rem  DESCRIPTION
Rem    This script is used by ESS RCU for Oracle database. It is used
Rem    during RCU system Load to grant privileges to component schema user
Rem    that are needed by ESS component.
Rem
Rem    This script does not grant privileges needed for AQ notification
Rem    support used by ESS in earlier releases. AQ notification is no longer
Rem    used as of ESS 12.2.1.3.0 (PS3). See ess_aqnotify_grants.sql script
Rem    for privileges needed for AQ notification support.
Rem
Rem  USAGE:
Rem    ess_priv_grants  <schema_user> <default_tablespace>
Rem
Rem    This script should be run as RCU admin user.
Rem
Rem  NOTES
Rem    For 12c RCU, this script is executed during SystemLoad when
Rem    connected as RCU admin user.
Rem
Rem    This script does NOT create the tablespaces. They must already exist.
Rem
Rem    See AVR/ess/notes/ess_rcu.txt for additional developer notes.
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  apfwkr      02/17/23 - CI# 35097629 of
Rem  apfwkr      02/17/23 - apfwkr_blr_backport_31443286_12.2.1.4.0 .
Rem  apfwkr      02/17/23 - CI# 35097629
Rem  apfwkr      02/17/23 - apfwkr_ci_backport_31443286_12.2.1.4.0soabp from
Rem  apfwkr      02/17/23 - main
Rem  apfwkr      07/17/20 - Backport pallacha_bug-31443286_12215 from main
Rem  pallacha    07/08/20 - Add privilege for ATP-DB
Rem  chall       10/17/16 - Created
Rem
Rem =======================================================================
Rem
Rem RE: Roles and Definer-Rights Behavior
Rem
Rem Roles are disabled when calling a definer-rights package, stored
Rem procedure, or function. Only privileges granted directly to that
Rem object (schema) owner are enabled for  method call.
Rem
Rem ---------------------------------------------------------------------
Rem
Rem RE: Grants needed for ESS use of Oracle Scheduler to support SQL jobs
Rem
Rem Must grant privileges directly to ESS due to definer-rights behavior.
Rem Some DBA_SCHEDULER_xxx views used by getSQLJobDetail and other ESS logic.
Rem See AVR/ess/notes/ess_rcu.txt for additional developer notes.
Rem
Rem ----------
Rem RE: EXECUTE privilege on Oracle Scheduler job class
Rem
Rem The Scheduler job owner must have EXECUTE privilege on the Scheduler
Rem job class in order for enable to succeed. The Scheduler job creator,
Rem if different than job owner, does not appear to need EXECUTE on job class.
Rem
Rem ----------
Rem RE: CREATE JOB, CREATE ANY JOB
Rem 
Rem For now, we grant both CREATE JOB and CREATE ANY JOB to ESS schema.
Rem The former is not absolutely needed if the latter more powerful privilege
Rem is granted, but does not hurt anything and may simplify future upgrade
Rem if this changes again.
Rem
Rem =======================================================================

Rem &&1 - schema user
Rem &&2 - tablespace

-- Grant the user unlimited quota to the tablespace.
alter user &&1 quota unlimited on &&2;

grant create session to &&1;
grant create view to &&1;
grant create synonym to &&1;
grant create table to &&1;
grant create sequence to &&1;
grant create procedure to &&1;

-- Make sure can use certain RDBMS packages (do not rely on a public grant).
-- The PUBLIC grant on some common Oracle packages is revoked for a hardended
-- database env.
grant execute on DBMS_LOCK to &&1;
grant execute on UTL_FILE to &&1;
grant execute on UTL_RAW to &&1;
grant execute on DBMS_LOB to &&1;
grant execute on DBMS_SCHEDULER to &&1;
grant execute on DBMS_XMLDOM to &&1;
grant execute on DBMS_APPLICATION_INFO to &&1;
grant execute on DBMS_UTILITY to &&1;
grant execute on DBMS_SESSION to &&1;
grant execute on DBMS_OUTPUT to &&1;
grant execute on SYS.DBMS_ASSERT to &&1;

-- Grant privileges to some dynamic views for instance/session info.
-- Need gv$instance for SQLJobDetail (EM) and may be handy in general.
grant select on sys.v_$instance to &&1;
grant select on sys.gv_$instance to &&1;
grant select on sys.v_$session to &&1;
grant select on sys.gv_$session to &&1;

grant select on sys.v_$parameter to &&1;

-- Grants needed for ESS use of Oracle Scheduler to support SQL jobs.
-- Additional comments at top of this script.
--%grant execute any class to &&1;
grant create any job to &&1;
grant create job to &&1;
grant manage scheduler to &&1;

grant select on dba_scheduler_jobs to &&1;
grant select on dba_scheduler_job_run_details to &&1;
grant select on dba_scheduler_running_jobs to &&1;
grant select on dba_scheduler_job_classes to &&1;

--%begin
--%  dbms_output.put_line('Schema user: &&1, Tablespace: &&2');
--%end;
--%/

rem ===== End: ess_priv_grants.sql ====================================
