Rem
Rem $Header: ess/sql/common_oracle/sqljob/post_sqljob_setup.sql /st_pcbpel_12.2.1.4.0soabp/2 2023/02/22 14:35:51 apfwkr Exp $
Rem
Rem post_sqljob_setup.sql
Rem
Rem Copyright (c) 2015, 2023, Oracle and/or its affiliates. 
Rem
Rem  NAME
Rem    post_sqljob_setup.sql - Post actions for SQL job setup
Rem
Rem  DESCRIPTION
Rem    This script performs additional actions needed after the main
Rem    Oracle Scheduler and AQ setup for SQL job support has been done.
Rem
Rem  NOTES
Rem    This script should be run by RCU admin user.
Rem
Rem    Assumes that CURRENT_SCHEMA has been set to ESS schema user.
Rem    The admin user must have be able to query ESS schema table.
Rem
Rem    For an EBR database, the session EDITION must be for ESS schema.
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  pallacha    09/27/21 - Backport pallacha_bug-33351665_fa from main
Rem  pallacha    09/14/21 - fix bug 33351665
Rem  apfwkr      07/17/20 - Backport pallacha_bug-31443286_12215 from main
Rem  pallacha    07/08/20 - Add fix for ATP-DB
Rem  chall       02/20/15 - Created
Rem
Rem =======================================================================

-- ========================================================================
-- Grant execute on Oracle Scheduler job class.
--
-- The Oracle Scheduler/AQ setup creates an Oracle Scheduler job class
-- that will be the default job class for Scheduler jobs created by the
-- ESS schema user. The Oracle Scheduler job owner must be able to execute
-- the Scheduler job class specified for the Scheduler job.
-- Oracle Scheduler job class objects are owned by SYS.
--
-- RE: Oracle Database Vault (DV) support
--
-- ESS RCU must be able to run in a Database Vault enabled environment.
-- There are differences in privileges granted to standard users (including
-- SYS) and standard roles. There is concept of Realms that can be a factor.
--
-- For a DV enabled db, the grant fails if done as ESS schema user
-- with "ORA-47401: Realm violation ....". Not sure of specifics but has
-- something to do Scheduler job class object being owned by SYS.
-- The grant works if done as RCU admin user (e.g., LCM_SUPER_ADMIN1).
--
-- The job class grant was formerly done by sqljob/ess_plsql_runtime.sql
-- as ESS schema user. It is now done during PostDataLoad as RCU admin
-- and works for both a non DV and DV environment.
-- ========================================================================

declare
  --%v_ess_schema varchar2(100) := '&&1';
  v_ess_schema varchar2(30) := sys_context('userenv', 'current_schema');
  v_sqljob_prefix varchar2(100) := null;
  v_job_class varchar2(100) := null;
  v_stmt varchar2(500) := null;
  v_atp_value varchar2(30) := null;
  v_is_non_atp boolean := false;

begin
  --%v_stmt := 'select sqljob_prefix from '||v_ess_schema||'.ess_config';
  --%dbms_output.put_line('Get ESS sqljob_prefix: '||v_stmt);
  --%execute immediate v_stmt into v_sqljob_prefix;

  select sqljob_prefix into v_sqljob_prefix from ess_config;
  dbms_output.put_line('ESS schema '||v_ess_schema||' uses sqljob prefix '||
                       v_sqljob_prefix);

  if v_sqljob_prefix is null then
    raise_application_error(-20000,
        'unable to get sqljob prefix for ESS schema '||v_ess_schema);
  end if;

  v_job_class := v_sqljob_prefix||'$JC_DEFAULT';

-- For ATP DV enabled DB, now the realm violation exception is not thrown and jobclass can be granted execute permission to public.
-- NO_DATA_FOUND : Below result gives No data for non-ATP DB, hence the ignoring the below exception. 
-- Only for Non ATP DB executing the grant on job class to public in postdataload as existing framework. 
-- ATP DB - grating permission while creating the job class only.

  begin
     dbms_output.put_line('postload dbms_db_version.version: '|| dbms_db_version.version);
     if (dbms_db_version.version) < '18' then
        v_is_non_atp := true;
        dbms_output.put_line('DB version is below 18');
        dbms_output.put_line('This looks to be a non ATP database and can be ignored.');
     else
        dbms_output.put_line('DB version is greater than equal to 18');
        -- select sys_context('userenv','cloud_service') into v_atp_value from dual;
        v_atp_value := nvl(lower(sys_context('userenv','cloud_service')), 'null');
        if (v_atp_value in ('dwcs','oltp','jdcs','paas')) then
           dbms_output.put_line('v_atp_value is: ' ||v_atp_value);
           v_is_non_atp := false;
        else
             v_is_non_atp := true;
             dbms_output.put_line('DB version is greater than 18 but is not ATP DB');
             dbms_output.put_line('This looks to be a non ATP database and can be ignored.');
        end if;
     end if;
   exception
     when NO_DATA_FOUND then
        v_is_non_atp := true;
        dbms_output.put_line('NO_DATA_FOUND');
        dbms_output.put_line('This looks to be a non ATP database and can be ignored.');
  end;
  if v_is_non_atp then
     dbms_output.put_line('Non ATP Database');
     v_stmt := 'grant execute on SYS.'||v_job_class||' to public';
     dbms_output.put_line('Grant execute on job class: '||v_stmt);
     execute immediate v_stmt;
  end if;

end;
/

Rem ===== End: post_sqljob_setup.sql ======================================
