/*
Rem Copyright (c) 2006, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem     deleteNoCompositeIdInstances.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Fabric purge
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       apfwkr   11/16/20 - Backport apfwkr_blr_backport_30701409_12.2.1.4.0
Rem                           from main
Rem       apfwkr   08/14/20 - Backport linlxu_bug-30701409_12212-main from main
Rem
*/
function delete_orp_component_instances(min_created_date in timestamp,
                                         max_created_date in timestamp,
                                         retention_period in timestamp,
                                         batch_size in integer,
					 composite_dn in varchar2
                                         ) return boolean is
    id_sql varchar2(4000) := '';
    total_rows integer;
    v_cmpst_stmt varchar2(2000) := '';
begin
       if composite_dn is not null then
	        v_cmpst_stmt := ' and component_dn like ''' || composite_dn || '%'''; 
       end if;
       id_sql := ' delete from component_instance where ';
       id_sql :=   id_sql || 'created_time >= ' || '''' || min_created_date || '''';
       id_sql := id_sql || ' and created_time <= ' || '''' || max_created_date || '''';
	   id_sql := id_sql || v_cmpst_stmt; 
       id_sql := id_sql || 'and composite_instance_id is null and rownum <=' || batch_size;
       execute immediate id_sql;
       total_rows := SQL%ROWCOUNT;
       debug_purge('component_instance');
       commit;
      if total_rows = batch_size then
        return true;
      else
         return false;
      end if ;

    exception
      when others then
        log_error('ERROR (delete_orph_component_instances)');
            raise;
end delete_orp_component_instances;
function delete_orp_reference_instances(min_created_date in timestamp,
                                         max_created_date in timestamp,
                                         retention_period in timestamp,
                                         batch_size in integer,
                                         purge_partitioned_component in boolean,
					 composite_dn in varchar2
                                         ) return boolean is
   id_sql varchar2(4000) := '';
    purge_id_table varchar2(100) := 'reference_instance_purge';
    delete_sql varchar2(1000);
    total_rows integer;
    more_rows_to_delete boolean;
    v_cmpst_stmt varchar2(2000) := '';                                    
    batch_total_count integer := 0;
                                  
begin
      if composite_dn is not null then
	        v_cmpst_stmt := ' and composite_dn like ''' || composite_dn || '%'''; 
       end if;
       id_sql := ' select id from reference_instance where ';
       id_sql :=   id_sql || 'created_time >= ' || '''' || min_created_date || ''''; 
       id_sql := id_sql || ' and created_time <= ' || '''' || max_created_date || ''''; 
       id_sql := id_sql || v_cmpst_stmt;
       id_sql := id_sql || 'and (composite_instance_id is null or composite_instance_id=0) and rownum <=' || batch_size;
       id_sql := 'insert into '||purge_id_table || '(id)' || id_sql;
       execute immediate 'truncate table ' || purge_id_table;
       execute immediate id_sql;
       total_rows := SQL%ROWCOUNT;
       debug_purge(purge_id_table, 'inserted = ');
       commit;
       delete_instance_payloads(purge_id_table, 'reference', purge_partitioned_component);
	   if purge_partitioned_component = true OR is_table_partitioned('REFERENCE_INSTANCE','CPST_PARTITION_DATE') = false then  
         delete_sql := 'delete from reference_instance where id in ( select id from ' || purge_id_table ||')';
       batch_total_count := batch_delete_func(delete_sql);   
       debug_purge2('reference_instance', batch_total_count);
       commit;           
       end if; 	   
      execute immediate 'truncate table ' || purge_id_table;
      if total_rows = batch_size then
        return true;
      else
         return false;
      end if ;  
      
    exception
      when others then
        log_error('ERROR (delete_orph_reference_instances)');        
	    raise;

end delete_orp_reference_instances;
function delete_orp_compinstfaults(min_created_date in timestamp,
                                         max_created_date in timestamp,
                                         retention_period in timestamp,                                         
                                         batch_size in integer,
          				 purge_partitioned_component in boolean,
                                         composite_dn in varchar2
                                         ) return boolean is
   id_sql varchar2(4000) := '';
    purge_id_table varchar2(100) := 'composite_fault_purge';
    delete_sql varchar2(1000);
    total_rows integer;
    v_cmpst_stmt varchar2(2000) := '';                                        
    batch_total_count integer := 0;
begin
	 	if composite_dn is not null then
	        v_cmpst_stmt := ' and composite_dn like ''' || composite_dn || '%'''; 
	    end if;
       id_sql := ' select id from composite_instance_fault where ';
       id_sql :=   id_sql || 'created_time >= ' || '''' || min_created_date || ''''; 
       id_sql := id_sql || ' and created_time <= ' || '''' || max_created_date || '''';
        id_sql := id_sql ||  v_cmpst_stmt;
       id_sql := id_sql || ' and ( composite_instance_id is null or composite_instance_id=0)  and rownum <=' || batch_size;
	    
       id_sql := 'insert into '||purge_id_table || '(id)'|| id_sql;
      execute immediate 'truncate table ' || purge_id_table;
      execute immediate id_sql;
      total_rows := SQL%ROWCOUNT;
      debug_purge(purge_id_table,'inserted = ');
      commit;       
      delete_instance_payloads(purge_id_table, 'service', purge_partitioned_component);
      delete_sql := 'delete from composite_instance_fault where id in ( select id from ' || purge_id_table ||')';
      batch_total_count := batch_delete_func(delete_sql);   
      debug_purge2('composite_instance_fault', batch_total_count);
      commit;               
      execute immediate 'truncate table ' || purge_id_table;
      
      if total_rows = batch_size then
        return true;
      else
         return false;
      end if   ;
      
    exception
      when others then
        log_error('ERROR (delete_orphaned_compositeinstancefaults)');        
	    raise;

end delete_orp_compinstfaults;  
  function deleteNoCompositeIdInstances(min_created_date in timestamp,
                                         max_created_date in timestamp,
                                         retention_period in timestamp,                                         
                                         batch_size in integer,
                                         purge_partitioned_component in boolean default false,
                                         composite_dn in varchar2										 
                                         ) 
                                         return boolean is

 more_rows_to_delete_all  boolean := false;
more_rows_to_delete  boolean :=false;                                         
                                         
begin
      more_rows_to_delete_all := delete_orp_reference_instances(min_created_date, 
                                               max_created_date,
                                               retention_period,                                               
                                               batch_size,
					       purge_partitioned_component,
					       composite_dn
                                               );
                                 
      more_rows_to_delete := delete_orp_compinstfaults(min_created_date, 
                                               max_created_date,
                                               retention_period,                                               
                                               batch_size,
					       purge_partitioned_component,
					       composite_dn
                                               );

      more_rows_to_delete := delete_orp_component_instances(min_created_date,
                                               max_created_date,
                                               retention_period,
                                               batch_size,
					       composite_dn
                                               );
     if(more_rows_to_delete = true) then
        more_rows_to_delete_all := true;
      end if ;
      return more_rows_to_delete_all;
    exception
      when others then
        log_error('ERROR (fabric.deleteNoCompositeIdInstances)');        
	    raise;
end deleteNoCompositeIdInstances ;
