/*
*
*
* deleteNoCompositeIdInstances.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. All rights reserved.
*
*    NAME
*      deleteNoCompositeIdInstances.sql - B2B purge script used to purge B2B tables
*      that do not have a composite instance Id
*
*
*    DESCRIPTION
*     This script is used to purge B2B tables rows that are created with instanace tracking off
*
*     Parameters:
*     p_older_than       Not used by B2B
*     p_rownum           Batch size, purge in batch size 
*     
*
*/


/*
* Procedure: deleteNoCompositeIdInstances
*
*    
*/
FUNCTION deleteNoCompositeIdInstances( p_min_creation_date in timestamp,
                               p_max_creation_date in timestamp,
                               p_older_than TIMESTAMP, p_rownum NUMBER,
                               write_file in utl_file.file_type default null)
RETURN BOOLEAN
AS
  v_stmt  VARCHAR2(2000);
  total_rows NUMBER;
BEGIN

  truncate_temp_tables();

  v_stmt := 'insert into b2b_purge_temp_bm(bm_id, bm_message_id, bm_payload_storage, bm_attachment_storage, bm_native_data_storage, bm_translated_data_storage, wm_packed_message, wm_payload_storage, am_payload, am_attachment_storage, ext_bm_id, am_id, wm_id)        SELECT bm.id, bm.message_id, bm.payload_storage, bm.attachment_storage, bm.native_data_storage, 
       	      bm.translated_data_storage,
       	      wm.packed_message, wm.payload_storage,  
	      am.payload, am.attachment_storage, ext.id, am.id, wm.id
       FROM b2b_business_message bm, b2b_wire_message wm, b2b_app_message am, b2b_ext_business_message ext
       WHERE am.FABRIC_COMPOSITE_INSTANCE_ID is null
       AND bm.CPST_INST_CREATED_TIME BETWEEN '||'''' ||  
       p_min_creation_date ||''''|| '  AND ' ||''''|| p_max_creation_date  ||''''|| '
       AND bm.wire_message = wm.id (+)
       AND bm.ext_business_message = ext.id (+)
       AND bm.app_message = am.id;
       AND ROWNUM <= ' || p_rownum;
  EXECUTE immediate v_stmt;
    total_rows := SQL%ROWCOUNT;
  debug_purge_both('b2b_purge_temp_bm', 'Inserted = ',write_file);
    if total_rows = 0 then
     log_info_both
      ('No B2B instances found with null composite instance ids',write_file);
     RETURN FALSE;
    end if;

    purge_b2b_tables();

    return TRUE;
EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;

END deleteNoCompositeIdInstances ;
