/*
*
* deleteComponentInstancesDOP.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. All rights reserved.
*
*    NAME
*      deleteComponentInstancesDOP.sql - Decision purge script 
*
*
*    DESCRIPTION
*     This script is used to purge Decision tables provided with a list of composite instance ids
*     in an idTable . since teh volume of data for decision is not going to be high , we are not going 
*     to follow a multi-threaded model for purging decision tables. 
*
*/

PROCEDURE deleteComponentInstances(p_id_table   IN VARCHAR2, 
                           p_max_count IN INTEGER,
                           p_min_creation_date in timestamp,
                           p_max_creation_date in timestamp,
                           p_older_than TIMESTAMP,
			   composite_dn in varchar2,
                           write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
  v_rownum INTEGER;
  v_cmpst_stmt varchar2(2000) := '';
BEGIN

EXECUTE IMMEDIATE 'TRUNCATE TABLE temp_brdecision_instance';

-- Add all ids that have a composite instance id
-- p_idTable has the pruned list, so add all to the temp table
v_stmt := 'INSERT INTO temp_brdecision_instance ' ||
              'SELECT bri.id  FROM BRDecisionInstance bri, '||p_id_table || ' comp WHERE bri.ecid = comp.ecid';
EXECUTE immediate v_stmt;
-- if we still have space, all the no composite instance id rows too
v_rownum := p_max_count - SQL%ROWCOUNT ;
debug_purge_both('temp_brdecision_instance', 'Inserted =',write_file);
IF v_rownum > 0 THEN
    if composite_dn is not null then
      v_cmpst_stmt := ' and component_dn like ''' || composite_dn || '%'''; 
    end if;	
    EXECUTE IMMEDIATE 'INSERT INTO temp_brdecision_instance(ID) ' ||
          'SELECT ID FROM BRDecisionInstance WHERE STATE != 0 AND CREATION_TIME < '||''''|| p_older_than  ||''''||
           'AND CPST_INST_CREATED_TIME BETWEEN '||''''|| p_min_creation_date||''''|| ' AND '||''''||p_max_creation_date ||'''' ||
		   v_cmpst_stmt ||
           'AND ROWNUM <=' || v_rownum||' and ECID is null ';
    debug_purge_both('temp_brdecision_instance ', 'Inserted = ',write_file);
END IF ;
purge_decision_tables(write_file);
EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;

END deleteComponentInstances;
