/*
*
* fabric_danglingdelete.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. All rights reserved.
*
*    NAME
*      fabric_danglingdelete.sql
*
*
*    DESCRIPTION
*      This procedure cleans up dangling records from the following tables.
*
*      REFERENCE_INSTANCE
*      REJECTED_MSG_NATIVE_PAYLOAD
*      INSTANCE_PAYLOAD
*      COMPOSITE_INSTANCE_FAULT
*      COMPOSITE_SENSOR_VALUE
*      COMPOSITE_INSTANCE_ASSOC
*      COMPONENT_INSTANCE
*      ATTACHMENT
*      ATTACHMENT_REF
*      XML_DOCUMENT
*
*/
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size NUMBER, v_stoptime in date, write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

       v_stmt := 'delete from reference_instance s where s.composite_instance_id NOT IN ' || 
                 '(select b.id from COMPOSITE_INSTANCE b)';
       if retention_period is not null then
           v_stmt := v_stmt || ' AND s.UPDATED_TIME <= ''' || retention_period || '''';
       end if;
       dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);                                 

       v_stmt := 'delete from rejected_msg_native_payload s where s.id NOT IN ' || 
                 '(select b.payload_key from instance_payload b)';  
       if retention_period is not null then
           v_stmt := v_stmt || ' AND s.RM_PARTITION_DATE <= ''' || retention_period || '''';
       end if;
       dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
       
       v_stmt := 'delete from instance_payload s where s.instance_id NOT IN ' || 
                 '(select b.id from COMPOSITE_INSTANCE b)';
       if retention_period is not null then
           v_stmt := v_stmt || ' AND s.CREATED_TIME <= ''' || retention_period || '''';
       end if;
       dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
     
       v_stmt := 'delete from composite_instance_fault s where s.composite_instance_id NOT IN ' || 
                 '(select b.id from COMPOSITE_INSTANCE b)';
       if retention_period is not null then
           v_stmt := v_stmt || ' AND s.CREATED_TIME <= ''' || retention_period || '''';
       end if;
       dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

       v_stmt := 'delete from composite_sensor_value s where s.composite_instance_id NOT IN ' || 
                 '(select b.id from COMPOSITE_INSTANCE b)';
       if retention_period is not null then
           v_stmt := v_stmt || ' AND s.CPST_PARTITION_DATE <= ''' || retention_period || '''';
       end if;
       dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

       v_stmt := 'delete from composite_instance_assoc s where s.assoc1_composite_instance_id NOT IN ' || 
                 '(select b.id from COMPOSITE_INSTANCE b)';
       if retention_period is not null then
           v_stmt := v_stmt || ' AND s.CREATED_TIME <= ''' || retention_period || '''';
       end if;
       dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

       v_stmt := 'delete from composite_instance_assoc s where s.assoc2_composite_instance_id NOT IN ' || 
                 '(select b.id from COMPOSITE_INSTANCE b)';
       if retention_period is not null then
           v_stmt := v_stmt || ' AND s.CREATED_TIME <= ''' || retention_period || '''';
       end if;
       dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

       v_stmt := 'delete from component_instance s where s.composite_instance_id NOT IN ' || 
                 '(select b.id from COMPOSITE_INSTANCE b)';
       if retention_period is not null then
           v_stmt := v_stmt || ' AND s.UPDATED_TIME <= ''' || retention_period || '''';
       end if;
       dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

       v_stmt := 'delete from attachment s where s.key NOT IN ' || 
                 '(select b.key from attachment_ref b)';
       dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

       v_stmt := 'delete from attachment_ref s where s.ecid NOT IN ' || 
                 '(select b.ecid from composite_instance b)';
       dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

       v_stmt := 'select count(*) from edn_event_error_store';
       EXECUTE IMMEDIATE v_stmt;
       IF SQL%ROWCOUNT > 10000 THEN
           v_stmt := 'delete from edn_event_error_store s where s.creation_time < sysdate - 60';
           dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
       END IF;

    if is_table_partitioned('XML_DOCUMENT','DOC_PARTITION_DATE') = FALSE then
       v_stmt := 'DELETE FROM XML_DOCUMENT xd ' || 
                 ' WHERE xd.document_id NOT IN (''PublicEventSubs'', ''NonEHFEventSubscriptions'') ' || 
                 ' AND NOT EXISTS (SELECT 1 FROM instance_payload ip ' || 
                 '         WHERE ip.payload_key = xd.document_id) ' || 
                 ' AND NOT EXISTS (SELECT 1 FROM document_dlv_msg_ref ddmr ' || 
                 '         WHERE ddmr.document_id = xd.document_id) ' || 
                 ' AND NOT EXISTS (SELECT 1 FROM xml_document_ref xdr ' || 
                 '         WHERE xdr.document_id = xd.document_id)  ' || 
                 ' AND NOT EXISTS (SELECT 1 FROM document_ci_ref dcr ' || 
                 '        WHERE dcr.document_id = xd.document_id) ' || 
                 ' AND NOT EXISTS (SELECT 1 FROM audit_details ad ' ||
                 '         WHERE ad.doc_ref = xd.document_id) ' ||
                 ' AND NOT EXISTS (SELECT 1 FROM B2B_DATA_STORAGE bds ' || 
                 '         WHERE bds.document_id = xd.document_id)'; 
       if retention_period is not null then
           v_stmt := v_stmt || ' AND xd.DOC_PARTITION_DATE <= ''' || retention_period || '''';
       end if;
       dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    end if;
END dangling_delete;
