/*
Rem
Rem Copyright (c) 2006, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem     delete_composite_instances.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Fabric purge
Rem
*/   
   procedure delete_instance_payloads(id_table in varchar2,instance_type in varchar2, purge_partitioned_component in boolean,write_file in utl_file.file_type default null) as

      delete_sql varchar2(1000);
     begin
	       if purge_partitioned_component = true OR is_table_partitioned('XML_DOCUMENT','DOC_PARTITION_DATE') = false then
           delete_sql := 'delete from xml_document doc' ||
                        ' where doc.document_id NOT IN (select distinct b2b.document_id from B2B_DATA_STORAGE b2b)' ||
                        ' and doc.document_id in (select ip.payload_key from instance_payload ip where ip.instance_id in ( select it.id from ' || id_table || ' it )' ||  
                        ' and ip.instance_type = ''' || instance_type || ''')';
    	   execute immediate delete_sql;
           debug_purge_both('xml_document','Deleted ',write_file);
           commit;    
            end if;
       if instance_type = 'service'  then
           delete_sql := 'delete from rejected_msg_native_payload where id in (
                                   select payload_key from instance_payload where instance_id in (select id from ' || id_table ||') and 
                                                                                  instance_type = '''|| instance_type ||''')';  
           execute immediate delete_sql;
          debug_purge_both('rejected_msg_native_payload','Deleted ',write_file);  
           commit;
       end if;
       
           delete_sql :=  'delete from instance_payload where instance_id in (select id from ' || id_table ||') and  instance_type = '''|| instance_type ||'''';
           execute immediate delete_sql;
           debug_purge_both('instance_payload','Deleted ',write_file);
           commit;
	 end delete_instance_payloads;

    function delete_compositeinstancefaults(composite_instance_id_table in varchar2,purge_partitioned_component in boolean,write_file in utl_file.file_type default null) return integer is
       
    id_sql varchar2(4000) := '';
    add_and boolean := false;
    
    purge_id_table varchar2(100) := 'composite_fault_purge';
    delete_sql varchar2(1000);
    total_rows integer;
    
    begin
	  
      id_sql := ' select id from composite_instance_fault where composite_instance_id in (select id from composite_instance_purge)';  
     
      id_sql := 'insert into '||purge_id_table ||'(id)' || id_sql;
      
     
      execute immediate 'truncate table ' || purge_id_table;
      
      execute immediate id_sql;
      
      total_rows := SQL%ROWCOUNT;
      
    	  delete_instance_payloads(purge_id_table, 'service',purge_partitioned_component,write_file);
        delete_sql := 'delete from composite_instance_fault where id in ( select id from ' || purge_id_table ||')';
        execute immediate delete_sql;
        debug_purge_both('composite_instance_fault','Deleted ',write_file);
	commit;    
      execute immediate 'truncate table ' || purge_id_table;
              
      return total_rows;
    exception
      when others then
        log_error_both('ERROR (delete_composite_faults)',write_file);
	    raise;
	  end delete_compositeinstancefaults;
    
    function delete_reference_instances(composite_instance_id_table in varchar2, purge_partitioned_component in boolean,write_file in utl_file.file_type default null) return integer is
       
    id_sql varchar2(4000) := '';
    add_and boolean := false;
    purge_id_table varchar2(100) :='reference_instance_purge';
    delete_sql varchar2(1000);
    total_rows integer;
    
    begin
	
      id_sql := ' select id from reference_instance where  composite_instance_id in (select id from composite_instance_purge)';
      id_sql := 'insert into '||purge_id_table ||'(id) ' || id_sql;
      execute immediate 'truncate table ' || purge_id_table;
      execute immediate id_sql;
      total_rows := SQL%ROWCOUNT;
      debug_purge_both(purge_id_table,'inserted = ',write_file);
      commit;        
      delete_instance_payloads(purge_id_table, 'reference', purge_partitioned_component,write_file);
      if purge_partitioned_component = true OR is_table_partitioned('REFERENCE_INSTANCE','CPST_PARTITION_DATE') = false then  
      delete_sql := 'delete from reference_instance where id in ( select id from ' || purge_id_table ||')';
      execute immediate delete_sql;  
      debug_purge_both('reference_instance','Deleted ',write_file);
      commit;  
	  end if;
      execute  immediate 'truncate table ' ||purge_id_table;
      
      return total_rows;
      
    exception
      when others then
        log_error_both('ERROR (delete_reference_instances)',write_file);        
	    raise;
	end delete_reference_instances;

  function  delete_component_instances(composite_instance_id_table in varchar2, purge_partitioned_component in boolean,write_file in utl_file.file_type default null) return integer is
    id_sql varchar2(4000) := '';
    add_and boolean := false;
    purge_id_table varchar2(100) :='component_instance_purge';
    delete_sql varchar2(1000);
    total_rows integer;

    begin
      id_sql := ' select id from component_instance where  composite_instance_id in  (select id from composite_instance_purge)';
      id_sql := 'insert into '||purge_id_table ||'(id) ' || id_sql;
      execute immediate 'truncate table ' || purge_id_table;
      execute immediate id_sql;
      total_rows := SQL%ROWCOUNT;
      debug_purge_both(purge_id_table,'inserted = ',write_file);
      commit;
      delete_instance_payloads(purge_id_table, 'component', purge_partitioned_component,write_file);
      if purge_partitioned_component = true OR is_table_partitioned('COMPONENT_INSTANCE','CPST_PARTITION_DATE') = false then
      delete_sql := 'delete from component_instance where id in ( select id from ' || purge_id_table ||')';
      execute immediate delete_sql;
      debug_purge_both('component_instance','Deleted ',write_file);
      commit;
          end if;
      execute  immediate 'truncate table ' ||purge_id_table;

      return total_rows;

    exception
      when others then
        log_error_both('ERROR (delete_component_instances)',write_file);
            raise;

  end delete_component_instances;  

  procedure deleteCompositeInstances(instance_id_table in varchar2, purge_partitioned_component in boolean default false,write_file in utl_file.file_type default null) is
    v_sql varchar2(1000);
    total_rows integer;
    purge_id_table varchar2(100) :='composite_instance_purge';
  begin
        v_sql :='insert into ' || purge_id_table || '(id) select id from composite_instance where ecid in (select ecid from '||instance_id_table||')';
            
      execute immediate 'truncate table ' ||purge_id_table;
      execute immediate v_sql;
        total_rows := delete_reference_instances(purge_id_table, purge_partitioned_component,write_file);
                                 
      total_rows := delete_compositeinstancefaults(purge_id_table,purge_partitioned_component,write_file); 
      
        delete_instance_payloads(purge_id_table, 'composite',purge_partitioned_component,write_file); 
        v_sql := 'delete from composite_sensor_value where composite_instance_id in ( select id from ' || purge_id_table ||')';
        execute immediate v_sql;
        debug_purge_both('composite_sensor_value','Deleted ',write_file);
        commit;
        v_sql := 'delete from composite_instance_assoc where assoc1_composite_instance_id in ( select id from ' || purge_id_table ||') or assoc2_composite_instance_id in ( select id from ' || purge_id_table ||')';
        execute immediate v_sql;
        debug_purge_both('composite_instance_assoc','Deleted ',write_file);
        commit;
        total_rows := delete_component_instances(purge_id_table, purge_partitioned_component,write_file);
        v_sql := 'delete from attachment where key in (select key from attachment_ref where ecid in (select ecid from '||instance_id_table||'))';
        execute immediate v_sql;
        debug_purge_both('attachment','Deleted ',write_file);
        commit;
        v_sql := 'delete from attachment_ref where ecid in (select ecid from '||instance_id_table ||')';
        execute immediate v_sql;
        debug_purge_both('attachment_ref','Deleted ',write_file);
        commit;  
        v_sql := 'delete from test_instance where composite_id in ( select id from ' || purge_id_table ||')';
        execute immediate v_sql;
        debug_purge_both('test_instance','Deleted ',write_file);
        commit;

		if purge_partitioned_component = true OR is_table_partitioned('COMPOSITE_INSTANCE','PARTITION_DATE') = false then   
        v_sql := 'delete from composite_instance where id in ( select id from ' || purge_id_table ||')';
        execute immediate v_sql;
        debug_purge_both('composite_instance','Deleted ',write_file);
        commit;
		end if;
    exception
      when others then
        log_error_both('ERROR (fabric.deleteCompositeInstances)',write_file);   
	    raise;
  end deleteCompositeInstances;
