/*
Rem $Header: pcbpel/admin/sqlutils12/soa11g_purge/oracle/mediator/mediator_createTempTables.sql /st_pcbpel_12.2.1.4.0soabp/1 2020/07/02 00:18:19 apfwkr Exp $
Rem
Rem mediator_createTempTables.sql
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      mediator_createTempTables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Mediator purge
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      05/14/20 - Backport linlxu_bug-29750407_12212-main from main
Rem    sanjain     07/13/10 - Fixing bug 9779594
Rem    sanjain     04/27/10 - Created
Rem
*/

PROCEDURE createTempTables(p_id_table   IN VARCHAR2, 
                           p_max_count IN INTEGER,
                           p_min_creation_date in timestamp,
                           p_max_creation_date in timestamp,
                           p_older_than TIMESTAMP,
			   composite_dn in varchar2,
                           write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
  v_rownum INTEGER;
  v_cmpst_stmt varchar2(2000) := '';
BEGIN

truncate_temp_tables() ;

-- p_idTable has the pruned list, so add all to the temp table
v_stmt := 'INSERT INTO temp_mediator_instance(id,ecid) ' ||
              'SELECT mi.id,mi.ecid FROM mediator_instance mi, '||p_id_table || ' 
               comp WHERE mi.ecid = comp.ecid';
EXECUTE immediate v_stmt;
commit;

-- If we still have space then add "NoCompositeInstanceIds" also
v_rownum := p_max_count - SQL%ROWCOUNT;
debug_purge_both('temp_mediator_instance', 'Inserted =',write_file);
IF v_rownum > 0 THEN 
    if composite_dn is not null then
		v_cmpst_stmt := ' and component_name like ''' || composite_dn || '%'''; 
	end if;	
    EXECUTE IMMEDIATE 'INSERT INTO temp_mediator_instance(id,ecid) ' || 'SELECT id,ecid FROM MEDIATOR_INSTANCE WHERE (COMPONENT_STATE <= 3 OR COMPONENT_STATE = 16) AND COMPOSITE_CREATION_DATE  BETWEEN '||'''' ||  p_min_creation_date ||''''|| '  AND ' ||''''|| p_max_creation_date  ||''''|| 
	v_cmpst_stmt ||
	' AND ROWNUM <= ' || v_rownum ||'  AND (COMPOSITE_INSTANCE_ID is null OR COMPOSITE_INSTANCE_ID = 0)'; 
    v_rownum := v_rownum - SQL%ROWCOUNT;
    debug_purge_both('temp_mediator_instance', 'Inserted =',write_file);
    commit;
END IF;

IF v_rownum > 0 THEN 
EXECUTE IMMEDIATE 'insert into temp_mediator_instance(id)' || 'select msg_id from mediator_DEFERRED_message a where status=2  and creation_date between '||'''' ||  p_min_creation_date ||''''|| '  AND ' ||''''|| p_max_creation_date  ||'''';
v_rownum := p_max_count - SQL%ROWCOUNT;
END IF;

v_rownum := p_max_count - SQL%ROWCOUNT;
IF v_rownum > 0 THEN
EXECUTE IMMEDIATE 'insert into temp_mediator_instance(id)' || 'select id from mediator_resequencer_message a where (status=2 or status=5) and creation_date between '||'''' ||  p_min_creation_date ||''''|| '  AND ' ||''''|| p_max_creation_date  ||'''';
v_rownum := v_rownum - SQL%ROWCOUNT;
END IF;

IF v_rownum > 0 THEN
EXECUTE IMMEDIATE 'insert into temp_mediator_instance(id)' || 'select a.id from mediator_resequencer_message a, mediator_group_status b where a.owner_id=b.id and b.component_status=1 and a.creation_date between '||'''' ||  p_min_creation_date ||''''|| '  AND ' ||''''|| p_max_creation_date  ||'''';
v_rownum := v_rownum - SQL%ROWCOUNT;
END IF;


EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;
END createTempTables;
