/*
*
* mediator_danglingdelete.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. All rights reserved.
*
*    NAME
*      mediator_danglingdelete.sql
*
*
*    DESCRIPTION
*      This procedure cleans up dangling records from the following tables.
*
*      MEDIATOR_PAYLOAD
*      MEDIATOR_RESEQUENCER_MESSAGE
*      MEDIATOR_GROUP_STATUS
*      MEDIATOR_DEFERRED_MESSAGE
*      MEDIATOR_AUDIT_DOCUMENT
*
*/
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size NUMBER, v_stoptime in date, write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

        -- purge mediator_payload
        if is_table_partitioned('MEDIATOR_PAYLOAD','CREATION_TIME') = FALSE then
           v_stmt := 'DELETE from mediator_payload s where s.owner_id NOT IN ' || 
                     '(select a.dummy1 from mediator_deferred_message a, mediator_instance b ' ||
                     'where a.msg_id = b.id)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

           v_stmt := 'DELETE from mediator_payload s where s.owner_id NOT IN ' || 
                     '(select c.id from mediator_case_instance c, mediator_instance d ' ||
                     'where c.instance_id = d.id)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
        end if;	

        v_stmt := 'DELETE from mediator_payload s where s.owner_id NOT IN ' || 
                  '(SELECT a.id FROM mediator_resequencer_message a, mediator_instance b ' ||
                  'WHERE a.id = b.id)';
        if retention_period is not null then
              v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

        v_stmt := 'DELETE from mediator_resequencer_message s where s.id NOT IN ' || 
                  '(SELECT b.id FROM mediator_instance b)';
        if retention_period is not null then
              v_stmt := v_stmt || ' AND s.CREATION_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

        v_stmt := 'DELETE from mediator_group_status s where s.resequencer_type != ''Standard''' || 
                  'and s.id NOT IN (SELECT b.owner_id FROM mediator_resequencer_message b)';
        if retention_period is not null then
              v_stmt := v_stmt || ' AND s.CREATION_DATE <= ''' || retention_period || '''';
        end if;

        -- purge mediator_deferred_message
        v_stmt := 'DELETE from mediator_deferred_message s where s.msg_id NOT IN ' || 
                  '(SELECT b.id FROM mediator_instance b)';
        if retention_period is not null then
              v_stmt := v_stmt || ' AND s.CREATION_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

        -- purge mediator_document
        v_stmt := 'DELETE from mediator_audit_document s where s.instance_id NOT IN ' || 
                  '(SELECT b.id FROM mediator_instance b)';
        if retention_period is not null then
              v_stmt := v_stmt || ' AND s.MI_PARTITION_DATE <= ''' || retention_period || '''';
        end if;
  
        -- purge mediator_case_detail
          v_stmt := 'DELETE from mediator_case_detail s where s.instance_id NOT IN ' || 
                  '(SELECT b.id FROM mediator_instance b)';
        if retention_period is not null then
              v_stmt := v_stmt || ' AND s.CREATED_TIME <= ''' || retention_period || '''';
        end if;
  
        -- purge mediator_case_instance
        if is_table_partitioned('MEDIATOR_CASE_INSTANCE','MI_PARTITION_DATE') = FALSE then
           v_stmt := 'DELETE from mediator_case_instance s where s.instance_id NOT IN ' || 
                  '(SELECT b.id FROM mediator_instance b)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.CREATED_TIME <= ''' || retention_period || '''';
           end if;
        end if;
  
        -- purge mediator_instance
        if is_table_partitioned('MEDIATOR_INSTANCE','COMPOSITE_CREATION_DATE') = FALSE then
           v_stmt := 'DELETE from mediator_instance s where s.ecid NOT IN ' || 
                  '(SELECT b.ecid FROM composite_instance b)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.CREATED_TIME <= ''' || retention_period || '''';
           end if;
        end if;
    
END dangling_delete;
