/*
Rem
Rem $Header: pcbpel/admin/sqlutils12/soa11g_purge/oracle/mediator/mediator_deleteNoCompositeIdInstances.sql /st_pcbpel_12.2.1.4.0soabp/1 2020/07/02 00:18:19 apfwkr Exp $
Rem
Rem mediator_deleteNoCompositeIdInstances.sql
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      mediator_deleteNoCompositeIdInstances.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      05/14/20 - Backport linlxu_bug-29750407_12212-main from main
Rem    sanjain     04/27/10 - Created
Rem
*/

FUNCTION deleteNoCompositeIdInstances( p_min_creation_date in timestamp,
                         p_max_creation_date in timestamp,
                         p_older_than TIMESTAMP, p_rownum NUMBER,
                         purge_partitioned_component in boolean default false,
                         composite_dn in varchar2,
                         ignore_state in boolean,
                         write_file in utl_file.file_type default null)
RETURN BOOLEAN
AS
  v_stmt  VARCHAR2(2000);
  bool1 BOOLEAN;
  bool2 BOOLEAN;
  bool3 BOOLEAN;
  bool4 BOOLEAN;
  v_cmpst_stmt varchar2(2000) := '';
  v_isMIPartitioned boolean := false;
  v_state_predicate varchar2(2000) := '';
  total_rows integer;

BEGIN

  truncate_temp_tables();

  v_stmt := 'Populate temp_mediator_instance using composite_creation_date' ;
   if composite_dn is not null then
     v_cmpst_stmt := ' and component_name like ''' || composite_dn || '%'''; 
   end if;

   if ignore_state = false then
     v_state_predicate := ' and (COMPONENT_STATE <= 3 OR COMPONENT_STATE = 16)';
   end if;

   if purge_partitioned_component = true OR is_table_partitioned('MEDIATOR_INSTANCE','COMPOSITE_CREATION_DATE') = FALSE then	 

    EXECUTE IMMEDIATE 'INSERT INTO temp_mediator_instance(id) ' || 'SELECT id FROM MEDIATOR_INSTANCE WHERE  COMPOSITE_CREATION_DATE  BETWEEN '||'''' ||  p_min_creation_date ||''''|| '  AND ' ||''''|| p_max_creation_date  ||''''|| v_state_predicate || v_cmpst_stmt || ' AND ROWNUM <= ' || p_rownum ||'  and (COMPOSITE_INSTANCE_ID is null OR COMPOSITE_INSTANCE_ID = 0)'; 

  else

        v_isMIPartitioned := true;
        EXECUTE IMMEDIATE 'INSERT INTO temp_mediator_instance(id) ' || 'SELECT id FROM MEDIATOR_INSTANCE WHERE  COMPOSITE_CREATION_DATE  BETWEEN '||'''' ||  p_min_creation_date ||''''|| '  AND ' ||''''|| p_max_creation_date  ||''''|| v_state_predicate || v_cmpst_stmt || ' and id not in (select id from temp_processed_mi) AND ROWNUM <= ' || p_rownum ||'  and (COMPOSITE_INSTANCE_ID is null OR COMPOSITE_INSTANCE_ID = 0)';
  end if;

  total_rows := SQL%ROWCOUNT;
  debug_purge_both('temp_mediator_instance', 'Inserted = ',write_file);
  if total_rows = 0 then
        log_info_both('No Mediator instances found with composite instance id as null or zero',write_file);
   bool1:=false;
else
       log_info_both('Mediator instances found with composite instance id '|| total_rows,write_file);
       if v_isMIPartitioned = true then
           execute immediate 'insert into temp_processed_mi select id from temp_mediator_instance';
       end if;
        bool1:=true;
  end if;

if ignore_state = false then
 v_state_predicate := ' and (b.component_status=1 or  (a.status=2 or a.status=5))';
end if;

EXECUTE IMMEDIATE 'insert into temp_mediator_instance(id)' || 'select a.id from mediator_resequencer_message a, mediator_group_status b where a.owner_id=b.id' || v_state_predicate || ' and a.creation_date between '||'''' ||  p_min_creation_date ||''''|| '  AND ' ||''''|| p_max_creation_date  ||''''|| '  and a.id not in (select id from mediator_instance)  AND ROWNUM <= ' || p_rownum;

total_rows := SQL%ROWCOUNT;
debug_purge_both('temp_mediator_instance', 'Inserted = ',write_file);

if total_rows = 0 then
        log_info_both('No Mediator instances found from mediator_resequencer_message ',write_file);
        bool2:=false;
else
        bool2:=true;
        log_info_both('Mediator instances found from mediator_resequencer_message'|| total_rows,write_file);
  end if;


 
if ignore_state = false then
 v_state_predicate := ' status=2  and';
end if;

EXECUTE IMMEDIATE 'insert into temp_mediator_instance(id)' || 'select msg_id from mediator_DEFERRED_message a where' || v_state_predicate || ' creation_date between '||'''' ||  p_min_creation_date ||''''|| '  AND ' ||''''|| p_max_creation_date  ||''''|| ' AND ROWNUM <= ' || p_rownum;

total_rows := SQL%ROWCOUNT;
debug_purge_both('temp_mediator_instance', 'Inserted = ',write_file);

if total_rows = 0 then
        log_info_both('No Mediator instances found in mediator_deferred_message',write_file);
        bool3:=false;
else
        bool3:=true;
        log_info_both('Mediator instances found in mediator_deferred_message '|| total_rows,write_file);
  end if;



if bool1=FALSE and bool2=FALSE and bool3=FALSE  then
return FALSE;
end if;

  delete_mediator_instances(purge_partitioned_component,write_file);

  return TRUE;
EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;

END deleteNoCompositeIdInstances ;
