Rem
Rem $Header: pcbpel/admin/sqlutils12/soa11g_purge/oracle/mediator/purge_mediator_oracle.sql /st_pcbpel_12.2.1.4.0soabp/1 2020/08/19 12:08:46 apfwkr Exp $
Rem
Rem purge_mediator_oracle.sql
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      purge_mediator_oracle.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Mediator tables
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    apfwkr      04/28/20 - Backport linlxu_bug-30490102_12212-main from main
Rem    sanjain     04/25/10 - Created
Rem

--Drop temp table for mediator instances
BEGIN
  IF table_exist('TEMP_MEDIATOR_INSTANCE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp_mediator_instance';
  END IF;

-- Create temporary table
  EXECUTE IMMEDIATE 'CREATE TABLE temp_mediator_instance
  (
    id           varchar2(100),
    ecid         varchar2(100)
  )';
  EXECUTE IMMEDIATE 'CREATE INDEX temp11g_med_inst_id 
on temp_mediator_instance(id)';
END;

/

CREATE OR REPLACE PACKAGE soa11g_mediator
AS
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size NUMBER, v_stoptime in date, write_file in utl_file.file_type default null);
                      
PROCEDURE deleteComponentInstances ( p_id_table   IN VARCHAR2, purge_partitioned_component in boolean default false,write_file in utl_file.file_type default null);

PROCEDURE pruneOpenECIDs ( p_id_table      IN VARCHAR2, 
                           p_prune_table IN VARCHAR2,
                           p_older_than TIMESTAMP,
                           write_file in utl_file.file_type default null);

FUNCTION  deleteNoCompositeIdInstances(p_min_creation_date in timestamp, 
                   p_max_creation_date in timestamp, 
                   p_older_than TIMESTAMP,
                   p_rownum NUMBER,
                   purge_partitioned_component in boolean default false,
                   composite_dn in varchar2,
                   ignore_state in boolean,
                   write_file in utl_file.file_type default null) 
RETURN BOOLEAN;

PROCEDURE createTempTables(p_id_table   IN VARCHAR2, 
                           p_max_count IN INTEGER,
                           p_min_creation_date in timestamp,
                           p_max_creation_date in timestamp,
                           p_older_than TIMESTAMP,
			   composite_dn in varchar2,
                           write_file in utl_file.file_type default null);

FUNCTION deleteComponentInstances(p_dop NUMBER, p_thread NUMBER, 
                         p_batch_size NUMBER default 20000,
                         p_stop_time DATE default NULL,
                         write_file utl_file.file_type default null, 
                         purge_partitioned_component in boolean default false) 
RETURN BOOLEAN;

FUNCTION isComponentPartitioned RETURN boolean;

function getComponentPartitionInfo return char;

END soa11g_mediator;
/
--show errors;
CREATE OR REPLACE PACKAGE body soa11g_mediator
AS
@@mediator_danglingdelete.sql
@@mediator_pruneOpenECIDs.sql
@@mediator_deleteComponentInstances.sql
@@mediator_deleteNoCompositeIdInstances.sql
@@mediator_deleteComponentInstancesDOP.sql
@@mediator_isComponentPartitioned.sql
@@mediator_createTempTables.sql
END soa11g_mediator;
/
--show errors;
