/*
*
* orabpel_danglingdelete.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. All rights reserved.
*
*    NAME
*      orabpel_danglingdelete.sql 
*
*
*    DESCRIPTION
*      This procedure cleans up dangling records from the following tables.
*
*      HEADERS_PROPERTIES
*      AG_INSTANCE
*      TEST_DETAILS
*      CUBE_SCOPE
*      AUDIT_COUNTER
*      AUDIT_TRAIL
*      AUDIT_DETAILS
*      CI_INDEXES
*      WORK_ITEM
*      WI_FAULT
*      DOCUMENT_DLV_MSG_REF
*      DOCUMENT_CI_REF
*      DLV_MESSAGE
*      DLV_SUBSCRIPTION
*      DLV_AGGREGATION
*      BPM_AUDIT_QUERY
*      BPM_MEASUREMENT_ACTIONS
*      BPM_MEASUREMENT_ACTION_EXCEPS
*      BPM_CUBE_AUDITINSTANCE
*      BPM_CUBE_TASKPERFORMANCE
*      BPM_CUBE_PROCESSPERFORMANCE
*      CUBE_INSTANCE
*
*/
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size NUMBER, v_stoptime in date, write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
BEGIN
-- Being purge of BPEL data

        v_stmt := 'DELETE FROM HEADERS_PROPERTIES s WHERE s.message_guid NOT IN ' || 
                  '(SELECT DISTINCT m.message_guid FROM document_dlv_msg_ref ddmr, dlv_message m WHERE ddmr.message_guid = m.message_guid)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

        v_stmt := 'DELETE FROM AG_INSTANCE s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.CREATION_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

        v_stmt := 'DELETE FROM TEST_DETAILS s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime);
    
        if is_table_partitioned('CUBE_SCOPE','CI_PARTITION_DATE') = FALSE then
           v_stmt := 'DELETE FROM CUBE_SCOPE s WHERE s.cikey NOT IN ' || 
                     '(SELECT ci.cikey FROM cube_instance ci)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
        end if;	

        if is_table_partitioned('AUDIT_COUNTER','CI_PARTITION_DATE') = FALSE then
           v_stmt := 'DELETE FROM AUDIT_COUNTER s WHERE s.cikey NOT IN ' || 
                     '(SELECT ci.cikey FROM cube_instance ci)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.CI_PARTITION_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
        end if;	

          IF (sysdate >= v_stoptime) THEN
              return;
          END IF;

        if is_table_partitioned('AUDIT_TRAIL','CI_PARTITION_DATE') = FALSE then
           v_stmt := 'DELETE FROM AUDIT_TRAIL s WHERE s.cikey NOT IN ' || 
                     '(SELECT ci.cikey FROM cube_instance ci)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.CI_PARTITION_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
        end if;	

        if is_table_partitioned('AUDIT_DETAILS','CI_PARTITION_DATE') = FALSE then
           v_stmt := 'DELETE FROM AUDIT_DETAILS s WHERE s.cikey NOT IN ' || 
                     '(SELECT ci.cikey FROM cube_instance ci)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.CI_PARTITION_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
        end if;	

        v_stmt := 'DELETE FROM CI_INDEXES s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

        v_stmt := 'DELETE FROM WI_FAULT s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

        v_stmt := 'DELETE FROM DOCUMENT_DLV_MSG_REF s WHERE s.message_guid NOT IN ' || 
                  '(SELECT DISTINCT m.message_guid FROM dlv_message m)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.DLV_PARTITION_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

        v_stmt := 'DELETE FROM DOCUMENT_CI_REF s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.CI_PARTITION_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

        IF (sysdate >= v_stoptime) THEN
              return;
        END IF;

        v_stmt := 'DELETE FROM DLV_MESSAGE s where s.STATE > 1 and s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.RECEIVE_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

        v_stmt := 'DELETE FROM DLV_SUBSCRIPTION s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.CI_PARTITION_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

        v_stmt := 'DELETE FROM DLV_AGGREGATION s WHERE s.cikey NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        if retention_period is not null then
           v_stmt := v_stmt || ' AND s.RECEIVE_DATE <= ''' || retention_period || '''';
        end if;
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

    -- ============ BPMN Tables ============
    IF table_exist('BPM_AUDIT_QUERY') THEN
        v_stmt := 'DELETE FROM BPM_AUDIT_QUERY WHERE component_instance_id NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime);
    END IF;

    IF table_exist('BPM_MEASUREMENT_ACTIONS') THEN
        v_stmt := 'DELETE FROM BPM_MEASUREMENT_ACTIONS WHERE component_instance_id NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime);
    END IF;

    IF table_exist('BPM_MEASUREMENT_ACTION_EXCEPS') THEN
        v_stmt := 'DELETE FROM BPM_MEASUREMENT_ACTION_EXCEPS WHERE component_instance_id NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime);
    END IF;

    IF table_exist('BPM_CUBE_AUDITINSTANCE') THEN
        v_stmt := 'DELETE FROM BPM_CUBE_AUDITINSTANCE WHERE componentinstanceid NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime);
    END IF;

    IF table_exist('BPM_CUBE_TASKPERFORMANCE') THEN
        v_stmt := 'DELETE FROM BPM_CUBE_TASKPERFORMANCE WHERE componentinstanceid NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime);
    END IF;

    IF table_exist('BPM_CUBE_PROCESSPERFORMANCE') THEN
        v_stmt := 'DELETE FROM BPM_CUBE_PROCESSPERFORMANCE WHERE componentinstanceid NOT IN ' || 
                  '(SELECT ci.cikey FROM cube_instance ci)';
        dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime);
    END IF;
    -- ============ BPMN Tables ============
 
        IF (sysdate >= v_stoptime) THEN
              return;
        END IF;
   
        if is_table_partitioned('CUBE_INSTANCE','CPST_INST_CREATED_TIME') = FALSE then
           v_stmt := 'DELETE FROM CUBE_INSTANCE s WHERE s.STATE >= 5 ' || 
                     'AND s.ecid NOT IN (SELECT unique tpic.ecid FROM composite_instance tpic)';
           if retention_period is not null then
              v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
           end if;
           dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
        end if;	

END dangling_delete;
