Rem
Rem
Rem purge_bpel_oracle.sql
Rem
Rem Copyright (c) 2009, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      purge_bpel_oracle.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Purges BPEL related tables.
Rem
Rem
-- To run bpel alone, create the int_array,ie.
-- create or replace type int_array as varray(10000) of integer;
--First drop temp table before procceding with creation
BEGIN
  IF table_exist('TEMP11G_CUBE_INSTANCE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp11g_cube_instance';
  END IF;
  IF table_exist('TEMP11G_DOCUMENT_CI_REF') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp11g_document_ci_ref';
  END IF;
  IF table_exist('TEMP11G_DOCUMENT_DLV_MSG_REF') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp11g_document_dlv_msg_ref';
  END IF;
  IF table_exists('TEMP11G_XML_DOCUMENT') THEN
    EXECUTE IMMEDIATE 'DROP TABLE temp11g_xml_document';
 END IF;
  -- Create temporary tables.
  EXECUTE IMMEDIATE 'CREATE TABLE temp11g_cube_instance  
(    
cikey INTEGER default ''0'',    
ecid VARCHAR2(100) default null
  
)';
  EXECUTE IMMEDIATE 'CREATE INDEX TEMP11g_CUBE_INST_CIKEY 
ON temp11g_cube_instance(CIKEY)';
  EXECUTE IMMEDIATE 'CREATE TABLE temp11g_document_ci_ref  
(    
document_id VARCHAR2(200),    
cikey INTEGER default ''0'',
ecid VARCHAR2(100) default null
)';
  EXECUTE IMMEDIATE 'CREATE TABLE temp11g_document_dlv_msg_ref  
(    
message_guid VARCHAR2( 50 ),
document_id VARCHAR2(200),    
cikey INTEGER default ''0'',    
ecid VARCHAR2(100) default null
)';
  EXECUTE IMMEDIATE 'CREATE INDEX temp11g_msg_guid  
on temp11g_document_dlv_msg_ref(message_guid)';
  EXECUTE IMMEDIATE 'CREATE INDEX temp11g_msg_id 
on temp11g_document_dlv_msg_ref(document_id)';
 EXECUTE IMMEDIATE 'CREATE TABLE temp11g_xml_document
(
document_id VARCHAR2(200),
cikey INTEGER default ''0'',
ecid VARCHAR2(100) default null
)';
 EXECUTE IMMEDIATE 'CREATE INDEX temp11g_xml_document_id
 on temp11g_xml_document(document_id)';

END;

/
CREATE OR REPLACE PACKAGE soa11g_orabpel
AS
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size NUMBER, v_stoptime in date, write_file in utl_file.file_type default null);
                      
PROCEDURE deleteComponentInstances ( p_id_table   IN VARCHAR2, purge_partitioned_component in boolean default false,ignore_state in boolean default false,write_file in utl_file.file_type default null);

PROCEDURE pruneOpenECIDs ( p_id_table IN VARCHAR2,
                           p_prune_table IN VARCHAR2,
                           p_older_than in TIMESTAMP,
                           write_file in utl_file.file_type default null);

FUNCTION  deleteNoCompositeIdInstances(p_min_creation_date in timestamp,
                     p_max_creation_date in timestamp,
                     p_older_than TIMESTAMP, p_rownum NUMBER, 
                     purge_partitioned_component in boolean default false,
		     soa_partition_name in varchar2,
                     composite_name in varchar2,
                     composite_revision in varchar2,
                     ignore_state in boolean default false,
                     write_file in utl_file.file_type default null) 
RETURN BOOLEAN;

PROCEDURE createTempTables(p_id_table   IN VARCHAR2,
                           p_max_count IN INTEGER,
                           p_min_creation_date in timestamp,
                           p_max_creation_date in timestamp,
                           p_older_than TIMESTAMP,
                           composite_name in  varchar2 ,
                           composite_revision in varchar2,
                           soa_partition_name in varchar2,
                           ignore_composite in boolean default false,
                           write_file in utl_file.file_type default null);

FUNCTION deleteComponentInstances(p_dop NUMBER, p_thread NUMBER,
                      p_batch_size NUMBER default 20000,
                      p_stop_time DATE default NULL,
                      write_file in utl_file.file_type default null, 
                      purge_partitioned_component in boolean default false) 
RETURN BOOLEAN;

FUNCTION isComponentPartitioned RETURN boolean;

function getComponentPartitionInfo return char;

END soa11g_orabpel;
/
--show errors;
CREATE OR REPLACE
PACKAGE body soa11g_orabpel
AS
@@orabpel_danglingdelete.sql
@@orabpel_pruneOpenCompositeIDs.sql
@@orabpel_deleteComponentInstances.sql
@@orabpel_deleteNoCompositeIdInstances.sql
@@orabpel_deleteComponentInstancesDOP.sql
@@orabpel_isComponentPartitioned.sql
END soa11g_orabpel;
/
--show errors;
