/*
Rem
Rem
Rem delete_instances_in_parallel.sql
Rem
Rem Copyright (c) 2006, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem    delete_instances_in_parallel.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       apfwkr   11/19/20 - Backport
Rem                           apfwkr_blr_backport_22329267_12.2.1.4.200917soabp
Rem                           from st_pcbpel_12.2.1.4.0soabp
Rem       apfwkr   11/18/20 - Backport apfwkr_blr_backport_22329267_12.2.1.4.0
Rem                           from main
Rem       apfwkr   05/14/20 - Backport linlxu_bug-29750407_12212-main from main
Rem       apfwkr   04/28/20 - Backport linlxu_bug-30490102_12212-main from main
Rem       apfwkr   11/16/20 - Backport linlxu_bug-22329267_12212-main from main
Rem       bpulappa 02/03/16 - XbranchMerge bpulappa_bug-22451485_r2 from
Rem                           st_pcbpel_pt-next
Rem       sanjain  04/29/10 - Enabling Mediator purge
Rem
*/
procedure createTempTables(
                   purge_id_table in varchar2,
                   max_count in integer,
                   min_creation_date in timestamp ,
                   max_creation_date in timestamp ,
                   retention_period in timestamp,
                   purge_partitioned_component in boolean,
                   componentPartInfo in  component_partition_info,
	           composite_dn in varchar2,
                   composite_name in  varchar2, 
                   composite_revision in varchar2,
                   soa_partition_name in varchar2,
                   keep_workflow_inst in boolean,
                   ignore_composite in boolean default false,
                   write_file in utl_file.file_type default null) is
begin
     log_info_both('parent createTempTables',write_file);
     if purge_partitioned_component = true OR componentPartInfo.bpelPartitioned= 'N' OR componentPartInfo.bpelPartitioned = 'P' then
             log_info_both('calling orabpel.createTempTables',write_file);
        soa11g_orabpel.createTempTables(purge_id_table,max_count,min_creation_date,max_creation_date,retention_period,  composite_name, composite_revision, soa_partition_name, ignore_composite, write_file);
      end if;
     if (ignore_composite = false) and (purge_partitioned_component = true OR componentPartInfo.mediatorPartitioned='N' OR componentPartInfo.mediatorPartitioned ='P') then
        soa11g_mediator.createTempTables(purge_id_table,max_count,min_creation_date,max_creation_date,retention_period, composite_dn,write_file);
     end if;
     if (ignore_composite = false) and (purge_partitioned_component = true OR componentPartInfo.workflowPartitioned='N') then
        soa11g_workflow.createTempTables(purge_id_table,max_count,min_creation_date,max_creation_date,retention_period, composite_dn,write_file);
     end if;
     if (ignore_composite = false) and (purge_partitioned_component = true OR componentPartInfo.fabricPartitioned='N' OR componentPartInfo.bpelPartitioned = 'P') then
        soa11g_fabric.createTempTables(purge_id_table,max_count,min_creation_date,max_creation_date,retention_period, composite_dn,write_file);
     end if;
end createTempTables;

procedure deleteNonParallelComponents(
                   purge_id_table in varchar2,
                   max_count in integer,
                   min_creation_date in timestamp ,
                   max_creation_date in timestamp ,
                   retention_period in timestamp,
                   purge_partitioned_component in boolean,
                   componentPartInfo in component_partition_info,
                   composite_dn	in varchar2,
                   write_file in utl_file.file_type default null) is
begin

     if purge_partitioned_component = true OR componentPartInfo.decisionPartitioned='N'
      then
       soa11g_decision.deleteComponentInstances(purge_id_table,max_count,min_creation_date,max_creation_date,retention_period, composite_dn,write_file);
    end if;

end deleteNonParallelComponents;

procedure delete_instances_in_parallel (
                   min_creation_date in timestamp,
                   max_creation_date in timestamp,
                   batch_size in integer default 20000,
                   -- max_runtime in integer default 60,
                   stoptime in varchar2 default null,
                   retention_period in timestamp default null,
                   DOP in integer default 4 ,
                   max_count in integer default 1000000,
                   purge_partitioned_component in boolean default false,
                   composite_name in  varchar2 default null,
                   composite_revision in varchar2 default null,
                   soa_partition_name in varchar2 default null,
                   keep_workflow_inst in boolean default false,
                   ignore_state in boolean default false,
                   ignore_composite in boolean default false,
                   sql_trace IN boolean default false	) is
                   
    composite_id_sql varchar2(4000);
    purge_id_table varchar2(100) := 'ecid_purge';
    -- stoptime varchar2(100) := to_char(sysdate + NVL(max_runtime,24*60)/(24*60),'DD/MON/YYYY:HH24/MI'); 
    total_rows integer;
    v_thread number := 0;
    v_jobname VARCHAR2(20);
    v_jobsrunning number;
    v_max_count number := max_count;
    v_jobflowsql varchar2(100);
    total_rows_after_pruning integer;
    purge_partitioned_comp_char char;
    prune_running_insts_table varchar2(100) :='prune_running_insts';
    componentPartInfo component_partition_info;
    v_retention_period timestamp := NVL(retention_period,max_creation_date);
    composite_dn varchar2(500);
    v_stoptime date := NULL;
    sql_trace_char varchar2(1);
    v_stmt  VARCHAR2(4000);
    write_file  utl_file.file_type;
    danglingpurgedone_rows integer;

    begin

      write_file := get_file11g_main;

      -- Check and exit if another purge is currently running.
      check_purge_session(write_file);
      -- Check and exit if the 11g to 12c upgrade is running.
      check_upgrade_session(write_file);
      -- Set ACTION_NAME on SESSION.
      DBMS_APPLICATION_INFO.SET_MODULE(
            MODULE_NAME => 'PARALLELPURGE11G',
            ACTION_NAME => 'SOAPURGEEXECUTING');

      log_info_both('***************************************',write_file);
      log_info_both('***************************************',write_file);
      log_info_both(' STARTING 11g PARALLEL loop PURGE    **',write_file);
      log_info_both('***************************************',write_file);
      log_info_both('***************************************',write_file);
      log_info_both('============================================= Begin SOA Parallel Purge ',write_file);
      log_info_both('min_creation_date => '
         ||TO_CHAR(min_creation_date,'DD/MON/YYYY:HH24/MI'),write_file);
      log_info_both('max_creation_date => '
        ||TO_CHAR(max_creation_date,'DD/MON/YYYY:HH24/MI'),write_file);
      log_info_both('batch_size => '|| batch_size);
      log_info_both('retention_period => '
         ||TO_CHAR(retention_period,'DD/MON/YYYY:HH24/MI'),write_file);
      log_info_both('composite_name => '||composite_name,write_file);
      log_info_both('composite_revision => '||composite_revision,write_file);
      log_info_both('soa_partition_name => '||soa_partition_name,write_file);
      if ignore_state then
         log_info_both('ignore_state is true, data will be purged irrespective of state ',write_file);
      end if; 
      if ignore_composite then
         log_info_both('ignore_composite is true, only completed bpel instance data will be purged !!!. ',write_file);
      end if; 
      log_info_both('DOP => '|| DOP,write_file);
      log_info_both('max_count => '|| max_count,write_file);
      v_stoptime := to_date(stoptime,'DD/MON/YYYY:HH24/MI');
      log_info_both
        ('stoptime = ' ||TO_CHAR(v_stoptime,'DD/MON/YYYY:HH24/MI'),write_file);

     --check whether any job is running or whether they shut down properly
     log_info_both('checking for jobs running',write_file);
      SELECT count(*) INTO v_jobsrunning FROM job_flow_control;
      log_info_both('jobs running = ' || v_jobsrunning,write_file);
      -- if not, raise an error and let the exception handling take care of it
      IF v_jobsrunning != 0 THEN
        raise_application_error (-20001,'Jobs still running or not shut down properly');
      END IF;
      if purge_partitioned_component = true then
        purge_partitioned_comp_char := 'Y';
      else
        purge_partitioned_comp_char := 'N';
      end if;

      if sql_trace then
        v_stmt := 'alter session set max_dump_file_size = unlimited';
        log_info_both(v_stmt,write_file);
        execute immediate v_stmt;
        v_stmt := 'alter session set events '
        || '''10046 trace name context forever, level 12''';
        log_info_both(v_stmt,write_file);
        execute immediate v_stmt;
        sql_trace_char := 'Y';
      end if;

      execute immediate 'delete from SOA_PURGE_LOG where LOG_DATE < sysdate - 60';
      execute immediate 'truncate table ' || purge_id_table;
      execute immediate 'truncate table ' || prune_running_insts_table;       
      composite_dn := make_composite_dn(soa_partition_name, composite_name, composite_revision);      
      log_info_both('composite_dn = ' || composite_dn,write_file);
      execute immediate 'truncate table edn_log_messages'; 

     if ignore_composite = false then --Only purge composite instance related data if ignore_composite is false
      composite_id_sql := ' select unique ecid from composite_instance where ' ;
      --states  COMPLETED_SUCCESSFULLY, FAULTED, TERMINATED_BY_USER, STALE,STATE_UNKNOWN 

      /* For 12c comment out state checking as all ECID will be pruned.
         --------------------------------------------------------------
      composite_id_sql :=   composite_id_sql || ' ( bitand(state,127)=1 or ';
      composite_id_sql :=   composite_id_sql ||  ' bitand(state,16)=16 or ';
      composite_id_sql :=   composite_id_sql ||  'bitand(state,64)=64 or ';
      if retention_period is not null then
        composite_id_sql :=   composite_id_sql ||  'state between 32 and 63 or ';
      end if;
      composite_id_sql :=   composite_id_sql ||  'state = 3 or state = 19) ';
      */

      composite_id_sql :=   composite_id_sql || ' created_time >= ' || '''' || min_creation_date || ''''; 
      composite_id_sql := composite_id_sql || ' and created_time <= ' || '''' || max_creation_date || ''''; 
      if composite_dn is not  null then 
         composite_id_sql := composite_id_sql || ' and composite_dn like ''' || composite_dn || '%''';
      end if;	  
      composite_id_sql := ' select * from ( ' || composite_id_sql || ' ) where rownum <= ' || v_max_count;
      composite_id_sql := 'insert into '||purge_id_table || composite_id_sql;
      execute immediate composite_id_sql;
      total_rows := SQL%ROWCOUNT;
      debug_purge_both(purge_id_table, ' inserted = ',write_file);
      commit;

      /* For 12c comment out state checking as all ECID will be pruned.
         --------------------------------------------------------------
      log_info('perform top-level pruning');
      log_info('total rows before top level pruning = '|| total_rows);
      toplevelprune(purge_id_table,prune_running_insts_table);
      SELECT count(*) INTO total_rows FROM ecid_purge;
      log_info('total rows after top level pruning = ' || total_rows);
      */
 
      log_info_both('total rows before pruning ' || total_rows,write_file);    
      log_info_both('calling pruneOpenECIDs ',write_file);
      pruneOpenECIDs (purge_id_table,prune_running_insts_table,v_retention_period,write_file);
      log_info_both('completed  pruneOpenECIDs ',write_file);
      SELECT count(*) INTO total_rows_after_pruning FROM ecid_purge;
      log_info_both
        ('total_rows_after_pruning ' || total_rows_after_pruning,write_file); 
     end if;

      log_info_both('creating temp  tables',write_file);
      componentPartInfo := getComponentPartitionInfo();
      createTempTables(purge_id_table,max_count,min_creation_date,max_creation_date,v_retention_period,purge_partitioned_component,componentPartInfo,composite_dn , composite_name,composite_revision,soa_partition_name,keep_workflow_inst,ignore_composite,write_file);
      log_info_both('completed creating temp tables',write_file);
     
      if ignore_composite = false then
      -- purge small volume data components which would not warrant multi-threaded purge
      log_info_both('purging small volume components',write_file);
      deleteNonParallelComponents(purge_id_table,max_count,min_creation_date,max_creation_date,v_retention_period,purge_partitioned_component,componentPartInfo,composite_dn,write_file);
      log_info_both('completed purging small volume components',write_file);
      end if;

      LOOP
          -- exit loop when DOP jobs have been started
             EXIT WHEN DOP=v_thread;
             v_jobname := 'SOA_PURGE_'||v_thread;
             v_jobflowsql := 'insert into job_flow_control  values (' || v_thread||')';
             execute immediate v_jobflowsql;
             commit;
             log_info_both
              ('inserting v_thread into job_flow_control ',write_file);
             log_info_both('spawning thread ' ||v_thread ,write_file);
             execute immediate 'BEGIN ' ||
             'dbms_scheduler.create_job (''' ||v_jobname||''',''STORED_PROCEDURE'',''soa11g.delete_insts_in_parallel_job'', 6); '||
             'dbms_scheduler.set_job_argument_value (''' ||v_jobname || ''',1,to_char(' ||DOP||')); ' ||
             'dbms_scheduler.set_job_argument_value (''' || v_jobname ||''' ,2,to_char('||v_thread||')); '||
             'dbms_scheduler.set_job_argument_value ('''|| v_jobname || ''',3,to_char('||batch_size||')); ' ||
             'dbms_scheduler.set_job_argument_value (''' ||v_jobname || ''',4,'''||stoptime||'''); ' ||
             'dbms_scheduler.set_job_argument_value (''' || v_jobname || ''',5,'''||purge_partitioned_comp_char||'''); ' ||
             'dbms_scheduler.set_job_argument_value (''' ||v_jobname ||''',6,'''||sql_trace_char||'''); ' ||
             'DBMS_SCHEDULER.SET_ATTRIBUTE (
                 '''||v_jobname||''', ''logging_level'', DBMS_SCHEDULER.LOGGING_FULL); '||
             'dbms_scheduler.enable ('''||v_jobname||'''); ' ||
             ' END; ';   
              v_thread := v_thread +1;
     END LOOP;
     log_info_both('thread spawning done',write_file);

      /* The deletion of report and statistical tables can be performed
         in parallel to the main SOA purge threads.
       */
      delete_stat_alert_tables
           (v_stoptime,
            v_max_count,
            batch_size,
            v_retention_period, 
            write_file);

      log_info_both('Purge Phase completed',write_file);
      IF (sysdate >= v_stoptime) THEN
           return;
      END IF;
/*
       v_stmt := 'select count(*) from SOA_PURGE_LOG where LOG_DATE > sysdate-60 AND PURGE_LOG like ''%finished dangling_delete%'' ';
       EXECUTE IMMEDIATE v_stmt into danglingpurgedone_rows;
      -- deleting dangling records for FA if ignore_composite = true and last attempt was over 2 month back , as this is expensiv
	log_info(' dangling_delete check ' || danglingpurgedone_rows);

      if ignore_composite and  danglingpurgedone_rows < 1 then
          
          log_info('  starting dangling_delete');
          IF (v_retention_period IS NULL) THEN
             v_retention_period := sysdate - 15;
          END IF;
          IF (v_retention_period > sysdate - 15) THEN
             v_retention_period := sysdate - 15;
          END IF;
          dangling_delete(v_retention_period, batch_size, stoptime, null, keep_workflow_inst);

          log_info('  finished dangling_delete');
	  commit;

          IF (sysdate >= v_stoptime) THEN
              return;
          END IF;

          v_stmt := 'DELETE FROM reference_instance ref ' ||
	                      'WHERE ref.PARENT_ID LIKE ''bpel:%'' ' ||
	                      'AND TO_NUMBER(SUBSTR(ref.PARENT_ID,6)) NOT IN (SELECT ci.cikey FROM cube_instance ci)';

	  if retention_period is not null then
	  	v_stmt := v_stmt || ' AND ref.CREATED_TIME <= ''' || retention_period || '''';
	  end if;

	  dangling_delete_proc(v_stmt, batch_size, v_stoptime);
	  commit;

      else
	  log_info('  skipped dangling_delete');
      end if;
*/
    close_file(write_file);
    -- Set ACTION_NAME on SESSION to NULL.
    DBMS_APPLICATION_INFO.SET_MODULE(MODULE_NAME => NULL, ACTION_NAME => NULL);

    EXCEPTION
     when others then
     close_file(write_file);
    DBMS_APPLICATION_INFO.SET_MODULE(MODULE_NAME => NULL, ACTION_NAME => NULL);
     log_error_both('ERROR(delete_instances_in_parallel',write_file);
     raise;

    end delete_instances_in_parallel;

