SET LINESIZE 128
Rem
Rem
Rem Copyright (c) 2010, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem     purge_soa_oracle.sql - Fabric purge script 
Rem
Rem
Rem    DESCRIPTION
Rem     This script is used to purge all non-running, non-recovery-required 
Rem      composite instances based on a given time range
Rem

BEGIN

  IF table_exist('SOA_PURGE_LOG') = false THEN
    EXECUTE IMMEDIATE 'CREATE TABLE SOA_PURGE_LOG (LOG_DATE TIMESTAMP, PURGE_LOG varchar2(2000))';
  END IF;
  IF table_exist('ECID_PURGE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE ECID_PURGE';
  END IF;
  IF table_exist('PRUNE_RUNNING_INSTS') THEN
    EXECUTE IMMEDIATE 'DROP TABLE PRUNE_RUNNING_INSTS';
  END IF;
  IF table_exist('TEMP_PROCESSED_CIKEY') THEN
    EXECUTE IMMEDIATE 'DROP TABLE TEMP_PROCESSED_CIKEY';
  END IF;
  IF table_exist('TEMP_PROCESSED_MI') THEN
    EXECUTE IMMEDIATE 'DROP TABLE TEMP_PROCESSED_MI';
  END IF;
  IF table_exist('JOB_FLOW_CONTROL') THEN
    EXECUTE IMMEDIATE 'DROP TABLE JOB_FLOW_CONTROL';
  END IF;

  EXECUTE IMMEDIATE 'CREATE TABLE prune_running_insts (ecid varchar2(100))';

  EXECUTE IMMEDIATE 'CREATE TABLE ecid_purge (ecid varchar2(100))';

  EXECUTE IMMEDIATE 'CREATE TABLE TEMP_PROCESSED_CIKEY(cikey number)';
  EXECUTE IMMEDIATE 'CREATE TABLE TEMP_PROCESSED_MI(id varchar2(100))';

  EXECUTE IMMEDIATE   'CREATE TABLE job_flow_control(job_thread number)';
END;
/

create or replace package soa11g as

      PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size NUMBER, p_stop_time INTEGER, write_file in utl_file.file_type default null, keep_workflow_inst in boolean default true);

      procedure delete_instances ( min_creation_date in timestamp,
                   max_creation_date in timestamp,
                   batch_size in integer default 20000, 
                   -- max_runtime in integer default 60, 
                   stoptime in date default null,
                   retention_period in timestamp default null,
                   purge_partitioned_component in boolean default false,
                    composite_name in  varchar2 default null,
                   composite_revision in varchar2 default null,
                   soa_partition_name in varchar2 default null,
                   keep_workflow_inst in boolean default false,
                   ignore_state in boolean default false,
                   sql_trace IN boolean default false
                   );    

procedure delete_instances_in_parallel (
                   min_creation_date in timestamp,
                   max_creation_date in timestamp,
                   batch_size in integer default 20000,
                   -- max_runtime in integer default 60,
                   stoptime in varchar2 default null,
                   retention_period in timestamp default null,
                   DOP in integer default 4,
                   max_count integer default 1000000,
                   purge_partitioned_component in boolean default false,
                   composite_name in  varchar2 default null,
                   composite_revision in varchar2 default null,
                   soa_partition_name in varchar2 default null,
                   keep_workflow_inst in boolean default false,
                   ignore_state in boolean default false,
                   ignore_composite in boolean default false,
                   sql_trace IN boolean default false
                            );

procedure delete_insts_in_parallel_job(DOP in number,
                                          thread_num in number,
                                          batch_size in number,
                                          p_stoptime in varchar2,
                                          purge_partitioned_component in char,
                                          keep_workflow_inst_char in char,
                                          sql_trace IN varchar2
                                          );                            
                                    
end soa11g;
/

create or replace package body soa11g as
  @@delete_instances.sql
  @@delete_insts_in_parallel_job.sql
  @@delete_instances_in_parallel.sql
end soa11g; 
/
show errors;

