/*
*
* hwf_danglingdelete.sql
*
* Copyright (c) 2010, 2020, Oracle and/or its affiliates. All rights reserved.
*
*    NAME
*      hwf_danglingdelete.sql
*
*
*    DESCRIPTION
*      This procedure cleans up dangling records from the following tables.
*
*      WFTask_TL
*      WFTaskHistory
*      WFTaskHistory_TL
*      WFComments
*      WFMessageAttribute
*      WFAttachment
*      WFAssignee
*      WFReviewer
*      WFCollectionTarget
*      WFRoutingSlip
*      WFNotification
*      WFTaskTimer
*      WFTaskError
*      WFHeaderProps
*      WFEvidence
*      WFTaskAssignmentStatistic
*      WFTaskAggregation
*      WFTask
*
*/
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size NUMBER, v_stoptime in date, write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

    v_stmt := 'DELETE FROM WFTask_TL s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.TASKCREATEDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

    v_stmt := 'DELETE FROM WFTaskHistory s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.UPDATEDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFTaskHistory_TL s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.TASKCREATEDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFComments s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.COMMENTDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFMessageAttribute s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.TASKCREATEDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFAttachment s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.UPDATEDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFAssignee s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.TASKCREATEDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFReviewer s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.TASKCREATEDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

    v_stmt := 'DELETE FROM WFCollectionTarget s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.TASKCREATEDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFRoutingSlip s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.TASKCREATEDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFNotification s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.TASKCREATEDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFTaskTimer s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.JOBDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFTaskError s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.ERRORDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFHeaderProps s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.TASKCREATEDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFEvidence s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.CREATEDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFTaskAssignmentStatistic s WHERE s.taskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.ENDDATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);
    
    v_stmt := 'DELETE FROM WFTaskAggregation s WHERE s.rootTaskId NOT IN ' || 
              '(SELECT task.taskId FROM WFTask task)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.UPDATEDDATE<= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

    v_stmt := 'DELETE FROM WFTask s ' || 
              'WHERE s.ecid NOT IN (SELECT comp.ecId FROM composite_instance comp)' || 
              'AND (  (s.componenttype = ''Workflow''' ||
              '        AND s.state IN (''DELETED'',''ERRORED'',''EXPIRED'',''STALE'',''WITHDRAWN'') )' ||
              '    OR (s.componenttype = ''BPMN'''||
              '        AND s.state IN ( ''DELETED'',''ERRORED'',''EXPIRED'',''STALE'',''WITHDRAWN'',''ABORTED'') ) ' || 
              '    )';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.UPDATEDDATE <= ''' || retention_period || '''';
    end if;
    --fa leaves dangling tasks for archival.. So no cleaning up of dangling task.. 
    --dangling_delete_proc(v_stmt, p_transaction_size, v_stoptime, write_file);

END dangling_delete;
