/*
*
* fabric_danglingdelete.sql
*
* Copyright (c) 2010, 2023, Oracle and/or its affiliates. 
*
*    NAME
*      fabric_danglingdelete.sql
*
*
*    DESCRIPTION
*      This procedure cleans up dangling records from the following tables.
*
*      SCA_ASYNC_CPNT_STATE 
*      SCA_COMMON_FAULT 
*      SCA_REJECTED_MESSAGE 
*      SCA_SENSOR_VALUE 
*      ATTACHMENT 
*      SCA_ATTACHMENT_REF 
*      AUDIT_TRAIL 
*      AUDIT_DETAILS 
*      SCA_FLOW_ASSOC 
*      SCA_META_DATA 
*      BPM_MEASUREMENT_ACTIONS 
*      BPM_MEASUREMENT_ACTION_EXCEPS 
*      BPM_AUDIT_QUERY_VARVALS_EXT1 
*      BPM_AUDIT_QUERY 
*      SCA_FLOW_TO_CPST 
*      TEST_INSTANCE 
*      XML_DOCUMENT
*
*/
PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size in NUMBER, v_stop_time in date, write_file in utl_file.file_type default null, purge_partitioned_component in boolean default false)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

    v_stmt := 'DELETE FROM SCA_ASYNC_CPNT_STATE s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM SCA_COMMON_FAULT s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.MODIFY_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM SCA_REJECTED_MESSAGE s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM SCA_SENSOR_VALUE s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM ATTACHMENT s WHERE s.KEY NOT IN ' || 
              '(SELECT ref.SCA_ATT_KEY FROM SCA_ATTACHMENT_REF ref ';
    if retention_period is not null then
       v_stmt := v_stmt || ' WHERE ref.PARTITION_DATE <= ''' || retention_period || ''')';
    else
       v_stmt := v_stmt || ' )';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
 
    v_stmt := 'DELETE FROM SCA_ATTACHMENT_REF s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM AUDIT_TRAIL s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.CI_PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM AUDIT_DETAILS s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.CI_PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM SCA_FLOW_ASSOC s WHERE s.OWNER_FLOW_ID <> -1 AND s.OWNER_FLOW_ID NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM SCA_FLOW_ASSOC s WHERE s.CORRELATED_FLOW_ID <> -1 AND s.CORRELATED_FLOW_ID NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM SCA_META_DATA s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

-- BPM tables also have runtime entires for HWF, so it will purged by FLOW_ID instead of QUERY_ID.

    v_stmt := 'DELETE FROM BPM_MEASUREMENT_ACTIONS s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.LAST_UPDATED <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM BPM_MEASUREMENT_ACTION_EXCEPS s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.LAST_UPDATED <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM BPM_AUDIT_QUERY_VARVALS_EXT1 s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM BPM_AUDIT_QUERY s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.CI_PARTITION_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

-- End of BPM tables.

    v_stmt := 'DELETE FROM SCA_FLOW_TO_CPST s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.UPDATED_TIME <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    v_stmt := 'DELETE FROM TEST_INSTANCE s WHERE s.flow_id <> -1 AND s.flow_id NOT IN ' || 
              '(SELECT sfi.flow_id FROM sca_flow_instance sfi)';
    if retention_period is not null then
       v_stmt := v_stmt || ' AND s.UPDATE_DATE <= ''' || retention_period || '''';
    end if;
    dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);

    if (purge_partitioned_component = TRUE) or (is_table_partitioned('XML_DOCUMENT','DOC_PARTITION_DATE') = FALSE) then
       v_stmt := 'DELETE FROM XML_DOCUMENT xd ' || 
                 ' WHERE NOT EXISTS (SELECT 1 FROM document_dlv_msg_ref ddmr ' || 
                 '         WHERE ddmr.document_id = xd.document_id) ' || 
                 ' AND NOT EXISTS (SELECT 1 FROM xml_document_ref xdr ' || 
                 '         WHERE xdr.document_id = xd.document_id)  ' || 
                 ' AND NOT EXISTS (SELECT 1 FROM document_ci_ref dcr ' || 
                 '        WHERE dcr.document_id = xd.document_id) ' || 
                 ' AND NOT EXISTS (SELECT 1 FROM audit_details ad ' ||
                 '         WHERE ad.doc_ref = xd.document_id) ' ||
                 ' AND NOT EXISTS (SELECT 1 FROM B2B_DATA_STORAGE bds ' || 
                 '         WHERE bds.document_id = xd.document_id)'; 
       dangling_delete_proc(v_stmt, p_transaction_size, v_stop_time, write_file);
    end if;

END dangling_delete;
