/*
Rem
Rem Copyright (c) 2006, 2023, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem     delete_composite_instances.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Fabric purge
Rem
*/   
PROCEDURE purge_fabric_tables_adhoc
AS
BEGIN

    DELETE FROM SCA_ASYNC_CPNT_STATE WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM SCA_COMMON_FAULT WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM SCA_REJECTED_MESSAGE WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM SCA_SENSOR_VALUE WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM ATTACHMENT WHERE KEY IN
       (SELECT SCA_ATT_KEY FROM SCA_ATTACHMENT_REF ref, temp_flowid_purge_glb tfp WHERE ref.flow_id = tfp.flow_id);
    COMMIT;
 
    DELETE FROM SCA_ATTACHMENT_REF WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM AUDIT_TRAIL WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM AUDIT_DETAILS WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM SCA_FLOW_ASSOC T1 WHERE EXISTS  (SELECT tfp.flow_id FROM  temp_flowid_purge_glb tfp  WHERE T1.OWNER_FLOW_ID = tfp.flow_id);
    COMMIT;

    DELETE FROM SCA_FLOW_ASSOC T1 WHERE EXISTS  (SELECT tfp.flow_id FROM  temp_flowid_purge_glb tfp  WHERE T1.CORRELATED_FLOW_ID = tfp.flow_id);
    COMMIT;

    DELETE FROM SCA_META_DATA WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM BPM_MEASUREMENT_ACTIONS WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM BPM_MEASUREMENT_ACTION_EXCEPS WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM BPM_AUDIT_QUERY_VARVALS_EXT1 WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM BPM_AUDIT_QUERY WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM SCA_FLOW_TO_CPST WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM TEST_INSTANCE WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

    DELETE FROM SCA_FLOW_INSTANCE WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge_glb tfp);
    COMMIT;

END purge_fabric_tables_adhoc;


PROCEDURE deleteComponentInstAdhoc
AS

BEGIN

    purge_fabric_tables_adhoc;

END deleteComponentInstAdhoc;
