/*
Rem
Rem Copyright (c) 2006, 2023, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem     delete_composite_instances.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Fabric purge
Rem
*/   
PROCEDURE purge_fabric_tables(purge_partitioned_component in boolean default false,write_file in utl_file.file_type default null)
AS
  v_stmt  VARCHAR2(2000);
BEGIN

v_stmt := 'Purge SCA_ASYNC_CPNT_STATE' ;
    DELETE FROM SCA_ASYNC_CPNT_STATE WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('SCA_ASYNC_CPNT_STATE','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge SCA_COMMON_FAULT';
    DELETE FROM SCA_COMMON_FAULT WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('SCA_COMMON_FAULT','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge SCA_REJECTED_MESSAGE';
    DELETE FROM SCA_REJECTED_MESSAGE WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('SCA_REJECTED_MESSAGE','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge SCA_SENSOR_VALUE';
    DELETE FROM SCA_SENSOR_VALUE WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('SCA_SENSOR_VALUE','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge ATTACHMENT';
    DELETE FROM ATTACHMENT WHERE KEY IN
     (SELECT SCA_ATT_KEY FROM SCA_ATTACHMENT_REF ref, temp_flowid_purge tfp WHERE ref.flow_id = tfp.flow_id);
    debug_purge_both('ATTACHMENT','Deleted ',write_file);
    COMMIT;
 
v_stmt := 'Purge SCA_ATTACHMENT_REF';
    DELETE FROM SCA_ATTACHMENT_REF WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('SCA_ATTACHMENT_REF','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge AUDIT_TRAIL';
    DELETE FROM AUDIT_TRAIL WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('AUDIT_TRAIL','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge AUDIT_DETAILS';
    DELETE FROM AUDIT_DETAILS WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('AUDIT_DETAILS','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge SCA_FLOW_ASSOC';
    DELETE FROM SCA_FLOW_ASSOC T1 WHERE exists (SELECT tfp.flow_id FROM temp_flowid_purge tfp  WHERE T1.OWNER_FLOW_ID = tfp.flow_id);
    debug_purge_both('SCA_FLOW_ASSOC','Deleted OWNER_FLOW',write_file);
    COMMIT;

v_stmt := 'Purge SCA_FLOW_ASSOC';
    DELETE FROM SCA_FLOW_ASSOC T1 WHERE exists (SELECT tfp.flow_id FROM temp_flowid_purge tfp  WHERE T1.CORRELATED_FLOW_ID = tfp.flow_id);
    debug_purge_both('SCA_FLOW_ASSOC','Deleted  CORRELATED_FLOW',write_file);
    COMMIT;

v_stmt := 'Purge SCA_META_DATA';
    DELETE FROM SCA_META_DATA WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('SCA_META_DATA','Deleted ',write_file);
    COMMIT;

-- BPM tables also have runtime entires for HWF, so it will purged by FLOW_ID instead of QUERY_ID.

v_stmt := 'Purge BPM_MEASUREMENT_ACTIONS';
    DELETE FROM BPM_MEASUREMENT_ACTIONS WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('BPM_MEASUREMENT_ACTIONS','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge BPM_MEASUREMENT_ACTION_EXCEPS';
    DELETE FROM BPM_MEASUREMENT_ACTION_EXCEPS WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('BPM_MEASUREMENT_ACTION_EXCEPS','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge BPM_AUDIT_QUERY_VARVALS_EXT1';
    DELETE FROM BPM_AUDIT_QUERY_VARVALS_EXT1 WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('BPM_AUDIT_QUERY_VARVALS_EXT1','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge BPM_AUDIT_QUERY';
    DELETE FROM BPM_AUDIT_QUERY WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('BPM_AUDIT_QUERY','Deleted ',write_file);
    COMMIT;

-- End of BPM tables.

v_stmt := 'Purge SCA_FLOW_TO_CPST';
    DELETE FROM SCA_FLOW_TO_CPST WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('SCA_FLOW_TO_CPST','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge TEST_INSTANCE';
    DELETE FROM TEST_INSTANCE WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('TEST_INSTANCE','Deleted ',write_file);
    COMMIT;

v_stmt := 'Purge SCA_FLOW_INSTANCE';
    DELETE FROM SCA_FLOW_INSTANCE WHERE flow_id in (SELECT tfp.flow_id FROM temp_flowid_purge tfp);
    debug_purge_both('SCA_FLOW_INSTANCE','Deleted ',write_file);
    COMMIT;

EXCEPTION
  when others then
    log_error_both(v_stmt,write_file);
    raise;

END purge_fabric_tables;


PROCEDURE deleteComponentInstances(instance_id_table IN VARCHAR2, purge_partitioned_component in boolean default false,write_file in utl_file.file_type default null)
AS
BEGIN

    purge_fabric_tables(purge_partitioned_component,write_file);

EXCEPTION
      when others then
        log_error_both('ERROR (fabric.deleteComponentInstances)',write_file);
            raise;

END deleteComponentInstances;
