Rem
Rem Copyright (c) 2006, 2020, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem     purge_fabric_oracle.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Fabric tables
Rem
Rem

BEGIN

  IF table_exist('TEMP_FLOWID_PURGE') THEN
    EXECUTE IMMEDIATE 'DROP TABLE TEMP_FLOWID_PURGE';
  END IF;
  IF table_exist('TEMP_FLOWID_PURGE_GLB') THEN
    EXECUTE IMMEDIATE 'DROP TABLE TEMP_FLOWID_PURGE_GLB';
  END IF;
  IF table_exist('TEMP_PRUNE_RUNNING_INSTS') THEN
    EXECUTE IMMEDIATE 'DROP TABLE TEMP_PRUNE_RUNNING_INSTS';
  END IF;

  EXECUTE IMMEDIATE 
          'CREATE TABLE temp_flowid_purge (flow_id number primary key)';

  EXECUTE IMMEDIATE 
          'CREATE GLOBAL TEMPORARY TABLE temp_flowid_purge_glb (flow_id number primary key) on commit preserve rows';

  EXECUTE IMMEDIATE 
          'CREATE TABLE temp_prune_running_insts (flow_id number primary key)';

END;
/

CREATE or REPLACE TYPE t_sfi_flowid is TABLE OF number;
/

CREATE OR REPLACE PACKAGE soa_fabric as

PROCEDURE dangling_delete(retention_period in date default null, p_transaction_size in NUMBER, v_stop_time in date, write_file in utl_file.file_type default null, purge_partitioned_component in boolean default false);
                      
PROCEDURE deleteComponentInstances(instance_id_table in varchar2,purge_partitioned_component in boolean default false,write_file in utl_file.file_type default null );

FUNCTION deleteComponentInstances(p_dop NUMBER, p_thread NUMBER,
                      p_batch_size NUMBER default 20000,
                      p_stop_time date default NULL,
                      write_file in utl_file.file_type default null,
                      purge_partitioned_component  in boolean default false) 
RETURN BOOLEAN;

PROCEDURE deleteComponentInstAdhoc;

function isComponentPartitioned return boolean;

function getComponentPartitionInfo return char;

end soa_fabric;
/

CREATE OR REPLACE PACKAGE BODY soa_fabric AS
@@fabric_danglingdelete.sql
@@fabric_deleteComponentInstances.sql
@@fabric_deleteComponentInstancesDOP.sql
@@fabric_deleteComponentInstAdhoc.sql
@@fabric_isComponentPartitioned.sql
END soa_fabric;    
/
--show errors ;
